/**
 * 
 */
package org.eaglei.model.jena;

import org.eaglei.model.EIURI;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public class BulkCurationQueryBuilder implements QueryBuilder {

	private static BulkCurationQueryBuilder queryBuilder;

	public static QueryBuilder getInstance() {
		if ( queryBuilder == null ) {
			queryBuilder = new BulkCurationQueryBuilder();
			return queryBuilder;
		} else {
			return queryBuilder;
		}

	}

	private BulkCurationQueryBuilder() {

	}

	@Override
	public String diagnoseQuery(EIURI typeURI, EIURI propertyURI, String object, RDFobjectType objectType) {
		if ( objectType == RDFobjectType.objectIsLiteral ) {
			return objectLiteralDiagnoseQuery( typeURI, propertyURI, object );
		} else {
			return objectResourceDiagnoseQuery( typeURI, propertyURI, object );
		}
	}

	private String objectLiteralDiagnoseQuery(EIURI typeURI, EIURI propertyURI, String object) {
		return SPARQLQueryUtil.getInstance().getSelectQueryByTripleWhenObjectIsLiteral( typeURI, propertyURI, object );

	}

	private String objectResourceDiagnoseQuery(EIURI typeURI, EIURI propertyURI, String object) {
		return SPARQLQueryUtil.getInstance().getSelectQueryByTripleWhenObjectIsResource( typeURI, propertyURI, EIURI.create( object ) );

	}

	@Override
	public String getQueryToAddObject(EIURI typeURI, EIURI propertyURI, String oldObjectURI, String newObjectURI, RDFobjectType objectType) {
		if ( objectType.equals( RDFobjectType.objectIsLiteral ) ) {
			return getQueryToAddObject( typeURI, propertyURI, oldObjectURI, newObjectURI );
		} else {
			return getQueryToAddObject( typeURI, propertyURI, EIURI.create( oldObjectURI ), EIURI.create( newObjectURI ) );
		}
	}

	private String getQueryToAddObject(EIURI typeURI, EIURI propertyURI, EIURI oldObjectURI, EIURI newObjectURI) {
		return "construct 	{?r_subject <" + propertyURI + "> <" + newObjectURI + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> <" + oldObjectURI + ">}";
	}

	private String getQueryToAddObject(EIURI typeURI, EIURI propertyURI, String oldObjectValue, String newObjectValue) {
		return "construct 	{?r_subject <" + propertyURI + "> \"" + newObjectValue + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> \"" + oldObjectValue + "\"}";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.model.jena.QueryBuilder#getQueryToAddPredicate(org.eaglei.model.EIURI, org.eaglei.model.EIURI, org.eaglei.model.EIURI, java.lang.String, org.eaglei.model.jena.QueryBuilder.RDFobjectType)
	 */
	@Override
	public String getQueryToAddPredicate(EIURI typeURI, EIURI oldpropertyURI, EIURI newPredicateURI, String object, RDFobjectType objectType) {
		if ( objectType.equals( RDFobjectType.objectIsLiteral ) ) {
			return getQueryToAddPredicate( typeURI, oldpropertyURI, newPredicateURI, object );
		} else {
			return getQueryToAddPredicate( typeURI, oldpropertyURI, newPredicateURI, EIURI.create( object ) );
		}
	}

	private String getQueryToAddPredicate(EIURI typeURI, EIURI oldpropertyURI, EIURI newPredicateURI, EIURI objectURI) {
		return "construct 	{?r_subject <" + newPredicateURI + "> <" + objectURI + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldpropertyURI + "> <" + objectURI + ">}";
	}

	private String getQueryToAddPredicate(EIURI typeURI, EIURI oldpropertyURI, EIURI newPredicateURI, String objectValue) {
		return "construct 	{?r_subject <" + newPredicateURI + "> \"" + objectValue + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldpropertyURI + "> \"" + objectValue + "\"}";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.model.jena.QueryBuilder#getQueryToDelteObject(org.eaglei.model.EIURI, org.eaglei.model.EIURI, java.lang.String, org.eaglei.model.jena.QueryBuilder.RDFobjectType)
	 */
	@Override
	public String getQueryToDelteTriple(EIURI typeURI, EIURI propertyURI, String object, RDFobjectType objectType) {

		if ( objectType.equals( RDFobjectType.objectIsLiteral ) ) {
			return getQueryToDelteObject( typeURI, propertyURI, object );
		} else {
			return getQueryToDelteObject( typeURI, propertyURI, EIURI.create( object ) );
		}
	}

	private String getQueryToDelteObject(EIURI typeURI, EIURI propertyURI, String object) {
		return "construct 	{?r_subject <" + propertyURI + "> \"" + object + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> \"" + object + "\"}";

	}

	private String getQueryToDelteObject(EIURI typeURI, EIURI propertyURI, EIURI object) {
		return "construct 	{?r_subject <" + propertyURI + "> <" + object + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> <" + object + ">}";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.model.jena.QueryBuilder#getQueryToAddPredicateAndObject(org.eaglei.model.EIURI, org.eaglei.model.EIURI, org.eaglei.model.EIURI, org.eaglei.model.EIURI, org.eaglei.model.EIURI, org.eaglei.model.jena.QueryBuilder.RDFobjectType)
	 */
	@Override
	public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObject, String newObject, RDFobjectType objectType) {

		if ( objectType.equals( RDFobjectType.objectIsLiteral ) ) {
			return getQueryToAddPredicateAndObject( typeURI, oldPredicateURI, newPredicateURI, oldObject, newObject );
		} else {
			return getQueryToAddPredicateAndObject( typeURI, oldPredicateURI, newPredicateURI, EIURI.create( oldObject ), EIURI.create( newObject ) );
		}

	}

	public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObject, String newObject) {
		return "construct 	{?r_subject <" + newPredicateURI + "> \"" + newObject + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldPredicateURI + "> \"" + oldObject + "\"}";
	}

	public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, EIURI oldObjectURI, EIURI newObjectURI) {
		return "construct 	{?r_subject <" + newPredicateURI + "> <" + newObjectURI + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldPredicateURI + "> <" + oldObjectURI + ">}";
	}

	@Override
	public String diagnoseQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex) {

		return SPARQLQueryUtil.getInstance().getSelectQueryByTripleWhenObjectIsRegex( typeURI, predicateURI, regex );
	}

	@Override
	public String getConstructQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex) {

		return "construct 	{?r_subject <" + predicateURI + "> ?r_object} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + predicateURI + "> ?r_object FILTER regex(str(?r_object),\"" + regex + "\",\"i\")}";
	}

}
