/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.MetadataConstants;
import org.eaglei.model.jena.SPARQLConstants;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.junit.Assert;
import org.junit.Test;

public class SPARQLQueryUtilTest {
    private static final SPARQLQueryUtil queryGenerator = SPARQLQueryUtil.getInstance();
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtilTest.class);
    private final String EI_INSTRUMENT = "http://purl.obolibrary.org/obo/ERO_0000004";
    private final EIURI EI_INSTRUMENT_URI = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000004");
    private final String EI_INSTRUMENT_LABEL;
    private final EIURI MOCK_USER_URI = EIURI.create((String)"http://alaska.eagle-i.net/i/0000012a-24f4-b98e-aa6f-a33780000000");
    private final EIURI MOCK_SUBJECT_URI = EIURI.create((String)"http://dev.alaska.eagle-i.net/i/INSTANCE_6ceac5c4-cb64-40f3-8451-d877d936430d");
    private final EIURI MOCK_LAB_URI = EIURI.create((String)"http://alaska.eagle-i.net/i/0000012a-2507-871c-a68e-378080000000");
    private final EIEntity MOCK_ENTITY_1 = EIEntity.create((String)"http://alaska.eagle-i.net/i/0000012a-2506-a4cf-a68e-378080000000", (String)"Boyer, Bert");
    private final EIEntity MOCK_ENTITY_2 = EIEntity.create((String)"http://alaska.eagle-i.net/i/0000012a-2506-a54b-a68e-378080000000", (String)"Black, Jynene");
    private final EIEntity MOCK_ENTITY_3 = EIEntity.create((String)"http://alaska.eagle-i.net/i/0000012a-2507-5dc7-a68e-378080000000", (String)"Bersamin, Andrea");
    private final EIEntity MOCK_ENTITY_4 = EIEntity.create((String)"http://alaska.eagle-i.net/i/0000012a-2507-71c2-a68e-378080000000", (String)"Kuhn, Tom");
    private final EIEntity MOCK_ENTITY_5 = EIEntity.create((String)"http://alaska.eagle-i.net/i/0000012a-2507-8820-a68e-378080000000", (String)"Topp, Carrie");

    public SPARQLQueryUtilTest() {
        this.EI_INSTRUMENT_LABEL = "Instrument";
    }

    @Test
    public void testIndividualPatterns() {
        StringBuilder sparql = new StringBuilder();
        sparql.append(queryGenerator.selectClause(SPARQLConstants.resultSetVariables));
        sparql.append(queryGenerator.referencedByPattern(this.MOCK_LAB_URI));
        sparql.append(queryGenerator.includeOwnerLabelPattern());
        sparql.append(queryGenerator.allTypesPattern(true));
        sparql.append(queryGenerator.ownerRestrictionPattern(this.MOCK_USER_URI, true));
        sparql.append(queryGenerator.providerRestrictionPattern(this.MOCK_LAB_URI));
        sparql.append(queryGenerator.modifiedDatePattern());
        sparql.append(queryGenerator.additionalLabelsPattern());
        sparql.append(queryGenerator.getStubPattern(true));
        sparql.append(queryGenerator.getStubPattern(false));
        sparql.append(queryGenerator.orderByLabelClosingClause());
        this.checkParsing(sparql.toString());
        StringBuilder sparqlNullValues = new StringBuilder();
        sparqlNullValues.append(queryGenerator.selectClause(SPARQLConstants.resultSetVariables));
        sparqlNullValues.append(queryGenerator.providerRestrictionPattern(EIURI.NULL_EIURI));
        sparqlNullValues.append(queryGenerator.orderByLabelClosingClause());
        this.checkParsing(sparqlNullValues.toString());
    }

    @Test
    public final void testGetAllPossibleOwnersQuery() {
        this.checkParsing(queryGenerator.getAllPossibleOwnersQuery());
    }

    @Test
    public void testGetResourcesForObjectPropertyValuesQuery() {
        this.checkParsing(queryGenerator.getResourcesForObjectPropertyValuesQuery(this.EI_INSTRUMENT_URI, this.MOCK_LAB_URI, MetadataConstants.DRAFT_ENTITY.getURI(), true));
        this.checkParsing(queryGenerator.getResourcesForObjectPropertyValuesQuery(this.EI_INSTRUMENT_URI, this.MOCK_LAB_URI, MetadataConstants.DRAFT_ENTITY.getURI(), false));
    }

    @Test
    public void testGetResourcesETLedFromFileQuery() {
        String query = queryGenerator.getResourcesETLedFromFileQuery("filename");
        this.checkParsing(query);
    }

    @Test
    public void testGetModifiedDateQuery() {
        String query = queryGenerator.getModifiedDateQuery(this.MOCK_LAB_URI);
        this.checkParsing(query);
    }

    @Test
    public void testGetReferencedByQuery() {
        this.checkParsing(queryGenerator.getReferencedByQuery(this.MOCK_LAB_URI));
    }

    @Test
    public void testGetEIResourcesByLabelQuery() {
        String query = queryGenerator.getEIResourcesByLabelQuery(this.EI_INSTRUMENT_URI, this.EI_INSTRUMENT_LABEL);
        this.checkParsing(query);
    }

    @Test
    public void testGetRetrieveLabelQuery() {
        String query = queryGenerator.getRetrieveLabelQuery(this.MOCK_SUBJECT_URI);
        this.checkParsing(query);
    }

    @Test
    public void getResourcesForObjectValuesQuery() {
        this.checkParsing(queryGenerator.getResourcesForObjectPropertyValuesQuery(this.EI_INSTRUMENT_URI, this.MOCK_LAB_URI, MetadataConstants.DRAFT_ENTITY.getURI(), true));
        this.checkParsing(queryGenerator.getResourcesForObjectPropertyValuesQuery(this.EI_INSTRUMENT_URI, EIURI.NULL_EIURI, MetadataConstants.DRAFT_ENTITY.getURI(), false));
        this.checkParsing(queryGenerator.getResourcesForObjectPropertyValuesQuery(this.EI_INSTRUMENT_URI, this.MOCK_LAB_URI, EIURI.NULL_EIURI, false));
        this.checkParsing(queryGenerator.getResourcesForObjectPropertyValuesQuery(this.EI_INSTRUMENT_URI, EIURI.NULL_EIURI, EIURI.NULL_EIURI, false));
    }

    @Test
    public void isClassGroup() {
        Assert.assertTrue((String)"should be class group", (boolean)queryGenerator.isClassGroup(EIURI.create((String)"http://eagle-i.org/ont/app/1.0/ClassGroup_ResourceProvider")));
        Assert.assertTrue((String)"should be class group", (boolean)queryGenerator.isClassGroup(EIURI.create((String)"http://eagle-i.org/ont/app/1.0/ClassGroupWhatever")));
        Assert.assertFalse((String)"should not be class group", (boolean)queryGenerator.isClassGroup(EIURI.create((String)"http://eagle-i.org/ont/app/1.0/ResourceProvider")));
        Assert.assertFalse((String)"should not be class group", (boolean)queryGenerator.isClassGroup(EIURI.create((String)"http://eagle-i.org/ont/app/1.0/PropertyGroup_PrimaryProperties")));
    }

    private void checkParsing(String query) {
        try {
            QueryFactory.create((String)query);
        }
        catch (QueryException e) {
            Assert.fail((String)("could not parse query: " + e.getMessage()));
        }
    }
}

