/**
 * 
 */
package org.eaglei.model.jena;

import org.eaglei.model.EIURI;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public interface QueryBuilder {

	enum RDFobjectType {
		objectIsLiteral, objectIsResource
	};

	public String getQueryToAddPredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String object, RDFobjectType objectType);
	public String getQueryToAddObject(EIURI typeURI, EIURI predicateURI, String oldObject, String newObject, RDFobjectType objectType);
	
	public String getQueryToDelteTriple(EIURI typeURI, EIURI predicateURI, String object, RDFobjectType objectType);
	
	//TODO:way too many parameters
	public String getQueryToAddPredicateAndObject(EIURI typeURI,EIURI oldPredicateURI,EIURI newPredicateURI,String oldObjectURI,String newObjectURI,RDFobjectType objectType);

	public String diagnoseQuery(EIURI typeURI, EIURI predicateURI, String object, RDFobjectType objectType);
	public String diagnoseQueryByRegex(EIURI typeURI, EIURI predicateURI, String object);
	
	public String getConstructQueryByRegex(EIURI typeURI, EIURI predicateURI,String regex);
	

}
