/**
 * The eagle-i consortium
 * Harvard University
 * Jul 1, 2010
 */
package org.eaglei.model.jena;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public class SPARQLConstants implements Serializable{
	public static final String SUBJECT_VARIABLE = "r_subject";
	public static final String LABEL_VARIABLE = "r_label";
	public static final String TYPE_VARIABLE = "r_type";
	public static final String TYPE_LABEL_VARIABLE = "r_typeLabel";
	public static final String STATE_VARIABLE = "r_state";
	public static final String STATE_LABEL_VARIABLE = "r_stateLabel";
	public static final String OWNER_VARIABLE = "r_owner";
	public static final String OWNER_NAME_VARIABLE = "r_ownerLabel";
	public static final String CREATION_DATE_VARIABLE = "r_created";
	public static final String MODIFIED_DATE_VARIABLE = "r_last_modified";
	public static final String PROVIDER_VARIABLE = "r_provider";
	public static final String PROVIDER_NAME_VARIABLE = "r_providerName";
	public static final String IS_STUB_VARIABLE = "r_is_stub";
	public static final String ANY_PREDICATE_VARIABLE = "any_predicate";

	
	
	
	public static final List<String> resultSetVariables = new ArrayList<String>() {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		{
			add( SUBJECT_VARIABLE );
			add( LABEL_VARIABLE );
			add( TYPE_VARIABLE );
			add( STATE_VARIABLE );
			add( OWNER_VARIABLE );
			add( OWNER_NAME_VARIABLE );
			add( CREATION_DATE_VARIABLE );
			add( MODIFIED_DATE_VARIABLE );
			add( PROVIDER_VARIABLE );
			add( PROVIDER_NAME_VARIABLE );
		}

	};
	
	private SPARQLConstants()
	{
		//for gwt
	}

}
