/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import org.eaglei.model.EIURI;
import org.eaglei.model.jena.QueryBuilder;
import org.eaglei.model.jena.SPARQLQueryUtil;

public class BulkCurationQueryBuilder
implements QueryBuilder {
    private static BulkCurationQueryBuilder queryBuilder;

    public static QueryBuilder getInstance() {
        if (queryBuilder == null) {
            queryBuilder = new BulkCurationQueryBuilder();
            return queryBuilder;
        }
        return queryBuilder;
    }

    private BulkCurationQueryBuilder() {
    }

    @Override
    public String diagnoseQuery(EIURI typeURI, EIURI propertyURI, String object, QueryBuilder.RDFobjectType objectType) {
        if (objectType == QueryBuilder.RDFobjectType.objectIsLiteral) {
            return this.objectLiteralDiagnoseQuery(typeURI, propertyURI, object);
        }
        return this.objectResourceDiagnoseQuery(typeURI, propertyURI, object);
    }

    private String objectLiteralDiagnoseQuery(EIURI typeURI, EIURI propertyURI, String object) {
        return SPARQLQueryUtil.getInstance().getSelectQueryByTripleWhenObjectIsLiteral(typeURI, propertyURI, object);
    }

    private String objectResourceDiagnoseQuery(EIURI typeURI, EIURI propertyURI, String object) {
        return SPARQLQueryUtil.getInstance().getSelectQueryByTripleWhenObjectIsResource(typeURI, propertyURI, EIURI.create((String)object));
    }

    @Override
    public String getQueryToAddObject(EIURI typeURI, EIURI propertyURI, String oldObjectURI, String newObjectURI, QueryBuilder.RDFobjectType objectType) {
        if (objectType.equals((Object)QueryBuilder.RDFobjectType.objectIsLiteral)) {
            return this.getQueryToAddObject(typeURI, propertyURI, oldObjectURI, newObjectURI);
        }
        return this.getQueryToAddObject(typeURI, propertyURI, EIURI.create((String)oldObjectURI), EIURI.create((String)newObjectURI));
    }

    private String getQueryToAddObject(EIURI typeURI, EIURI propertyURI, EIURI oldObjectURI, EIURI newObjectURI) {
        return "construct \t{?r_subject <" + propertyURI + "> <" + newObjectURI + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> <" + oldObjectURI + ">}";
    }

    private String getQueryToAddObject(EIURI typeURI, EIURI propertyURI, String oldObjectValue, String newObjectValue) {
        return "construct \t{?r_subject <" + propertyURI + "> \"" + newObjectValue + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> \"" + oldObjectValue + "\"}";
    }

    @Override
    public String getQueryToAddPredicate(EIURI typeURI, EIURI oldpropertyURI, EIURI newPredicateURI, String object, QueryBuilder.RDFobjectType objectType) {
        if (objectType.equals((Object)QueryBuilder.RDFobjectType.objectIsLiteral)) {
            return this.getQueryToAddPredicate(typeURI, oldpropertyURI, newPredicateURI, object);
        }
        return this.getQueryToAddPredicate(typeURI, oldpropertyURI, newPredicateURI, EIURI.create((String)object));
    }

    private String getQueryToAddPredicate(EIURI typeURI, EIURI oldpropertyURI, EIURI newPredicateURI, EIURI objectURI) {
        return "construct \t{?r_subject <" + newPredicateURI + "> <" + objectURI + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldpropertyURI + "> <" + objectURI + ">}";
    }

    private String getQueryToAddPredicate(EIURI typeURI, EIURI oldpropertyURI, EIURI newPredicateURI, String objectValue) {
        return "construct \t{?r_subject <" + newPredicateURI + "> \"" + objectValue + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldpropertyURI + "> \"" + objectValue + "\"}";
    }

    @Override
    public String getQueryToDelteTriple(EIURI typeURI, EIURI propertyURI, String object, QueryBuilder.RDFobjectType objectType) {
        if (objectType.equals((Object)QueryBuilder.RDFobjectType.objectIsLiteral)) {
            return this.getQueryToDelteObject(typeURI, propertyURI, object);
        }
        return this.getQueryToDelteObject(typeURI, propertyURI, EIURI.create((String)object));
    }

    private String getQueryToDelteObject(EIURI typeURI, EIURI propertyURI, String object) {
        return "construct \t{?r_subject <" + propertyURI + "> \"" + object + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> \"" + object + "\"}";
    }

    private String getQueryToDelteObject(EIURI typeURI, EIURI propertyURI, EIURI object) {
        return "construct \t{?r_subject <" + propertyURI + "> <" + object + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + propertyURI + "> <" + object + ">}";
    }

    @Override
    public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObject, String newObject, QueryBuilder.RDFobjectType objectType) {
        if (objectType.equals((Object)QueryBuilder.RDFobjectType.objectIsLiteral)) {
            return this.getQueryToAddPredicateAndObject(typeURI, oldPredicateURI, newPredicateURI, oldObject, newObject);
        }
        return this.getQueryToAddPredicateAndObject(typeURI, oldPredicateURI, newPredicateURI, EIURI.create((String)oldObject), EIURI.create((String)newObject));
    }

    public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObject, String newObject) {
        return "construct \t{?r_subject <" + newPredicateURI + "> \"" + newObject + "\"} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldPredicateURI + "> \"" + oldObject + "\"}";
    }

    public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, EIURI oldObjectURI, EIURI newObjectURI) {
        return "construct \t{?r_subject <" + newPredicateURI + "> <" + newObjectURI + ">} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + oldPredicateURI + "> <" + oldObjectURI + ">}";
    }

    @Override
    public String diagnoseQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex) {
        return SPARQLQueryUtil.getInstance().getSelectQueryByTripleWhenObjectIsRegex(typeURI, predicateURI, regex);
    }

    @Override
    public String getConstructQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex) {
        return "construct \t{?r_subject <" + predicateURI + "> ?r_object} where {?r_subject a <" + typeURI + "> . ?r_subject  <" + predicateURI + "> ?r_object FILTER regex(str(?r_object),\"" + regex + "\",\"i\")}";
    }
}

