/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.MetadataConstants;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EIInstanceMinimalFactory {
    private static EIOntModel ontModel;
    private static final Log logger;
    private static final boolean isDebugEnabled;
    private static final EIInstanceMinimalFactory INSTANCE;

    public static EIInstanceMinimalFactory getInstance() {
        return INSTANCE;
    }

    private EIInstanceMinimalFactory() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        ontModel = (EIOntModel)context.getBean(EIOntModel.class);
    }

    public EIInstanceMinimal createEmptyMinimal(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = this.safeGetClass(typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstanceMinimal ei = EIInstanceMinimal.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        return ei;
    }

    public List<EIInstanceMinimal> create(ResultSet resultSet) {
        if (resultSet == null) {
            return Collections.emptyList();
        }
        HashMap<EIURI, EIInstanceMinimal> instances = new HashMap<EIURI, EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        while (resultSet.hasNext()) {
            QuerySolution solution = resultSet.next();
            if (solution.contains("r_subject") && solution.contains("r_type") && solution.contains("r_label")) {
                EIInstanceMinimal ei = this.processMandatoryVariables(solution, instances, instanceList);
                if (ei == null) continue;
                ei.setWFOwner(this.getEntityFromSolution(solution, "r_owner", "r_ownerLabel"));
                ei.setWFState(this.getEntityFromSolution(solution, "r_state", ""));
                ei.setCreationDate(this.getStringFromSolution(solution, "r_created"));
                ei.setModifiedDate(this.getStringFromSolution(solution, "r_last_modified"));
                ei.setLab(this.getEntityFromSolution(solution, "r_provider", "r_providerName"));
                ei.setIsStub(this.getBooleanFromSolution(solution, "r_is_stub"));
                continue;
            }
            if (!isDebugEnabled) continue;
            logger.debug((Object)("Query solution without type, label or subject: " + solution));
        }
        return instanceList;
    }

    private EIInstanceMinimal processMandatoryVariables(QuerySolution solution, Map<EIURI, EIInstanceMinimal> instances, List<EIInstanceMinimal> instanceList) {
        EIInstanceMinimal ei;
        EIURI instanceUri = this.getUriFromSolution(solution, "r_subject");
        EIURI instanceType = this.getUriFromSolution(solution, "r_type");
        String label = this.getStringFromSolution(solution, "r_label");
        if (this.safeGetClass(instanceType) == null) {
            if (isDebugEnabled) {
                logger.debug((Object)("Query solution without EIClass: " + solution));
            }
            return null;
        }
        if (!instances.containsKey(instanceUri)) {
            ei = this.createEmptyMinimal(instanceType, EIEntity.create((EIURI)instanceUri, (String)label));
            instances.put(instanceUri, ei);
            instanceList.add(ei);
        } else {
            ei = instances.get(instanceUri);
            if (isDebugEnabled) {
                logger.debug((Object)("Processing query solution for an already processed instance: " + ei));
            }
            ei.addEIType(EIEntity.create((EIURI)instanceType, (String)""));
        }
        return ei;
    }

    public void setReferencingInstances(EIInstance instance, ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        List objectProperties = ontModel.getProperties(instance.getInstanceType().getURI());
        HashMap<EIURI, EIInstanceMinimal> instances = new HashMap<EIURI, EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        block0: while (resultSet.hasNext()) {
            QuerySolution solution = resultSet.next();
            if (solution.contains("r_subject") && solution.contains("r_type") && solution.contains("r_label")) {
                EIInstanceMinimal ei = this.processMandatoryVariables(solution, instances, instanceList);
                if (ei == null || this.safeGetClass(ei.getInstanceType().getURI()) == null) continue;
                EIClass currentClass = ontModel.getClass(ei.getInstanceType().getURI());
                Set currentClassAnnotations = ontModel.getClassAnnotations(currentClass.getEntity().getURI());
                if (currentClass != null && currentClassAnnotations != null && currentClassAnnotations.contains("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
                    ei.setDataModelRootSuperClass(currentClass.getEntity());
                } else {
                    List superclasses = ontModel.getSuperClasses(ei.getInstanceType().getURI());
                    if (superclasses == null || superclasses.size() == 0) {
                        ei.setDataModelRootSuperClass(ei.getInstanceType());
                    } else {
                        ei.setDataModelRootSuperClass(((EIClass)superclasses.get(superclasses.size() - 1)).getEntity());
                    }
                }
                List<EIURI> referencedByClassProperties = this.getOntPropertyUris(ontModel.getProperties(ei.getInstanceType().getURI()));
                EIURI referencePredicate = this.getUriFromSolution(solution, "any_predicate");
                if (referencePredicate == EIURI.NULL_EIURI || !referencedByClassProperties.contains(referencePredicate)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Referencing property: " + referencePredicate));
                }
                String referencePredicateStr = referencePredicate.toString();
                for (EIProperty property : objectProperties) {
                    String inverseProperty;
                    if (!(property instanceof EIObjectProperty) || !referencePredicateStr.equals(inverseProperty = ((EIObjectProperty)property).getInverseURI())) continue;
                    instance.addMaterializedInverseProperty(property.getEntity(), ei);
                    instanceList.remove(ei);
                    if (!logger.isDebugEnabled()) continue block0;
                    logger.debug((Object)("Inferred inverse property: " + property.getEntity() + "   value: " + ei));
                    continue block0;
                }
                continue;
            }
            if (!isDebugEnabled) continue;
            logger.debug((Object)("Query solution without type, label or subject: " + solution));
        }
        instance.setReferencedByList(instanceList);
    }

    private List<EIURI> getOntPropertyUris(List<EIProperty> properties) {
        ArrayList<EIURI> propUris = new ArrayList<EIURI>(properties.size());
        for (EIProperty property : properties) {
            propUris.add(property.getEntity().getURI());
        }
        return propUris;
    }

    private static EIClass safeGetClass(EIOntModel ontModel, EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }

    private static EIInstanceMinimal createEmptyMinimal(EIOntModel ontModel, EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = EIInstanceMinimalFactory.safeGetClass(ontModel, typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstanceMinimal ei = EIInstanceMinimal.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        return ei;
    }

    private EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create((String)solution.getResource(uriVariable).getURI());
            if ("r_state".equals(uriVariable)) {
                return MetadataConstants.getStatusEntity(uri);
            }
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create((EIURI)uri, (String)label);
        }
        return EIEntity.NULL_ENTITY;
    }

    private EIURI getUriFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return EIURI.create((String)solution.getResource(variable).getURI());
        }
        return EIURI.NULL_EIURI;
    }

    private String getStringFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString();
        }
        return "";
    }

    private boolean getBooleanFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString().equals("True");
        }
        return false;
    }

    private EIClass safeGetClass(EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }

    static {
        logger = LogFactory.getLog(EIInstanceMinimalFactory.class);
        isDebugEnabled = logger.isDebugEnabled();
        INSTANCE = new EIInstanceMinimalFactory();
    }
}

