package org.eaglei.model.webapp.client.searchbar;

import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.suggest.client.SearchSuggestOracle;

import com.google.gwt.core.client.GWT;

public class TermSuggestBox extends AbstractSearchBox {

    private static class TermSuggestOracle extends SearchSuggestOracle {
        private String classId;

        public TermSuggestOracle() {
            super(GWT.getModuleBaseURL());
        }

        /*
        void setClassId(EIURI classId) {
            if (classId != null) {
                this.classId = URL.encodeComponent(classId.toString());
            } else {
                this.classId = null;
            }
        }
        */

        protected String createURL(String callbackName, int id, String query) {
            String url = super.createURL(callbackName, id, query);
            if (classId != null) {
                return url + "&classid=" + classId;
            } else {
                return url;
            }
        }
    }
    
    public TermSuggestBox() {
        super(new TermSuggestOracle(), "TermSuggestBox");
    }

    @Override
    public String getDefaultText() {
        return "enter term name";
    }

    @Override
    public String getSearchBaseURL() {
        return null;
    }

    /*
    public void setClassId(EIURI classId) {
        ((TermSuggestOracle) sbSearch.getSuggestOracle()).setClassId(classId);
    }
    */
}
