package org.eaglei.model.webapp.client;

import org.eaglei.model.EIClass;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;

public class TermRequest extends Composite {

    private class TermRequestForm extends CommentForm {
        TermRequestForm() {
            super("[Term Request]  Parent class: ");
        }

        @Override
        protected void submitComment(Comment comment) {
            commentService.submitTermRequest(comment, new AsyncCallback<String>() {
                
                @Override
                public void onSuccess(String result) {
                    setSending(false);
                    onCancel();
                    Window.alert("Your term request was successfully submitted.");
                }
                
                @Override
                public void onFailure(Throwable caught) {
                    setSending(false);
                    Window.alert("Error submitting your term request.");
                }
            });
            setSending(true);
        }

        @Override
        protected void onCancel() {
            setSending(false);
            open.setVisible(true);
            commentTitle.setVisible(false);
            comment.setVisible(false);
            instructions.setVisible(false);
        }
    }

    private final VerticalPanel outer = new VerticalPanel();
    
    private EIClass currentClass;

    private Label commentTitle;
    private Anchor open;
    private CommentForm comment;
    private Label instructions;

    TermRequest() {
        SimplePanel wrapper = new SimplePanel();
        wrapper.setStyleName("MainComponent");
        wrapper.setWidget(outer);
        initWidget(wrapper);
        
        commentTitle = new Label("Term Request");
        outer.add(commentTitle);
        commentTitle.setStyleName("commentTitle");
        instructions = new Label("Please select the parent class of the new term being requested.");
        instructions.setStyleName("TermRequestInstructions");
        outer.add(instructions);
        instructions.setVisible(false);
        
        open = new Anchor("Submit a Term Request >>");
        outer.add(open);
        
        comment = new TermRequestForm();
        outer.add(comment);
        
        open.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				open.setVisible(false);
		        commentTitle.setVisible(true);
				comment.setVisible(true);
		    	instructions.setVisible(currentClass == null);
			}
		});
        commentTitle.setVisible(false);
        comment.setVisible(false);

    }
    
    public void setClass(EIClass clazz) {
    	currentClass = clazz;
    	instructions.setVisible(comment.isVisible() && clazz == null);
    	comment.setResource(clazz);
    	comment.setSending(false);
    }
}
