/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.webapp.client;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public abstract class AbstractNavigatorPanel
extends Composite {
    private static final int MAX_TOPICS = 5;
    private static final int MARGIN_INCREMENT = 6;
    private static final String STANDARD_TEXT_INDENT = "-10px";
    private static final String ARROW_TEXT_INDENT = "-14px";
    private final VerticalPanel outer = new VerticalPanel();
    private int currentMargin;
    private Image loadingImage = new Image("images/loading.gif");
    private EIClass currentClass;

    AbstractNavigatorPanel() {
        this.initWidget((Widget)this.outer);
    }

    private UIObject addLabel(EIClass c, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
        UIObject ui = this.addLabel(c.getEntity().getLabel(), c.isInferred());
        this.setClassDefinitionTooltip(c, ui, mapNoDefClassToUIObject);
        return ui;
    }

    private UIObject addLabel(String labelString, boolean isInferred) {
        Label l = new Label(labelString);
        DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)STANDARD_TEXT_INDENT);
        DOM.setStyleAttribute((Element)l.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
        DOM.setStyleAttribute((Element)l.getElement(), (String)"fontWeight", (String)"bold");
        if (isInferred) {
            DOM.setStyleAttribute((Element)l.getElement(), (String)"fontStyle", (String)"italic");
        }
        this.outer.add((Widget)l);
        return l;
    }

    private UIObject addAncestorLink(EIClass c, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
        UIObject ui = this.addLink(c, true, false, mapNoDefClassToUIObject);
        return ui;
    }

    private UIObject addSubClassLink(EIClass c, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
        UIObject ui = this.addLink(c, false, c.hasSubClass(), mapNoDefClassToUIObject);
        return ui;
    }

    private UIObject addLink(EIClass c, boolean displayArrow, boolean bold, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
        Label ui = this.addLink(c.getEntity().getLabel(), c.getEntity().getURI(), c.isInferred(), displayArrow, bold);
        this.setClassDefinitionTooltip(c, (UIObject)ui, mapNoDefClassToUIObject);
        return ui;
    }

    private Label addLink(String labelString, EIURI typeBindingURI, boolean isInferred, boolean displayArrow, boolean bold) {
        Label l;
        if (displayArrow) {
            l = new Label("< " + labelString);
            DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)ARROW_TEXT_INDENT);
        } else {
            l = new Label(labelString);
            DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)STANDARD_TEXT_INDENT);
        }
        DOM.setStyleAttribute((Element)l.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
        if (bold) {
            DOM.setStyleAttribute((Element)l.getElement(), (String)"fontWeight", (String)"bold");
        }
        l.setStyleName("link");
        if (isInferred) {
            l.addStyleDependentName("inferred");
        }
        l.addMouseOverHandler((MouseOverHandler)new /* Unavailable Anonymous Inner Class!! */);
        l.addMouseOutHandler((MouseOutHandler)new /* Unavailable Anonymous Inner Class!! */);
        l.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.outer.add((Widget)l);
        return l;
    }

    public void setClass(EIClass clazz) {
        if (clazz == null && this.currentClass == null && this.outer.getWidgetCount() > 0) {
            return;
        }
        this.currentClass = clazz;
        this.outer.clear();
        this.currentMargin = 18;
        if (clazz == null) {
            this.addLoading();
            this.getRootClasses();
        } else {
            this.addLink(this.getAllLinkLabel(), null, false, true, false);
            this.setSuperClasses(clazz);
        }
    }

    protected abstract String getAllLinkLabel();

    protected abstract void getRootClasses();

    protected void setRootClasses(List<EIClass> result) {
        if (this.currentClass != null || this.outer.getWidget(this.outer.getWidgetCount() - 1) != this.loadingImage) {
            return;
        }
        this.removeLoading();
        this.currentMargin += 6;
        HashMap mapNoDefClassToUIObject = new HashMap();
        for (EIClass top : result) {
            this.addSubClassLink(top, mapNoDefClassToUIObject);
        }
        this.getClassDefinitions(mapNoDefClassToUIObject);
    }

    private void setSuperClasses(EIClass c) {
        if (!c.hasSuperClass()) {
            this.currentMargin += 6;
            HashMap mapNoDefClassToUIObject = new HashMap();
            this.addLabel(c, mapNoDefClassToUIObject);
            this.setSubClasses(c);
            this.getClassDefinitions(mapNoDefClassToUIObject);
        } else {
            this.addLoading();
            ClientModelManager.INSTANCE.getSuperClasses(c, (ClientModelManager.SuperClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void setSubClasses(EIClass c) {
        if (c.hasSubClass()) {
            this.addLoading();
            ClientModelManager.INSTANCE.getSubClasses(c, (ClientModelManager.SubClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void setClassDefinitionTooltip(EIClass clazz, UIObject ui, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
        if (clazz.getDefinition() == null) {
            mapNoDefClassToUIObject.put(clazz, ui);
        } else {
            ui.setTitle(clazz.getDefinition());
        }
    }

    private void getClassDefinitions(HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
        if (mapNoDefClassToUIObject.size() > 0) {
            ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(mapNoDefClassToUIObject.keySet());
            ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, (ClientModelManager.ClassDefinitionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void addLoading() {
        this.outer.add((Widget)this.loadingImage);
        DOM.setStyleAttribute((Element)this.loadingImage.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
    }

    private void removeLoading() {
        this.outer.remove(this.outer.getWidgetCount() - 1);
    }

    static /* synthetic */ EIClass access$000(AbstractNavigatorPanel x0) {
        return x0.currentClass;
    }

    static /* synthetic */ VerticalPanel access$100(AbstractNavigatorPanel x0) {
        return x0.outer;
    }

    static /* synthetic */ Image access$200(AbstractNavigatorPanel x0) {
        return x0.loadingImage;
    }

    static /* synthetic */ void access$300(AbstractNavigatorPanel x0) {
        x0.removeLoading();
    }

    static /* synthetic */ int access$412(AbstractNavigatorPanel x0, int x1) {
        return x0.currentMargin += x1;
    }

    static /* synthetic */ UIObject access$500(AbstractNavigatorPanel x0, EIClass x1, HashMap x2) {
        return x0.addAncestorLink(x1, x2);
    }

    static /* synthetic */ UIObject access$600(AbstractNavigatorPanel x0, EIClass x1, HashMap x2) {
        return x0.addLabel(x1, x2);
    }

    static /* synthetic */ void access$700(AbstractNavigatorPanel x0, EIClass x1) {
        x0.setSubClasses(x1);
    }

    static /* synthetic */ void access$800(AbstractNavigatorPanel x0, HashMap x1) {
        x0.getClassDefinitions(x1);
    }

    static /* synthetic */ UIObject access$900(AbstractNavigatorPanel x0, EIClass x1, HashMap x2) {
        return x0.addSubClassLink(x1, x2);
    }
}

