package org.eaglei.model.webapp.client;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.NonResourceBaseClassesCallback;
import org.eaglei.model.webapp.client.SideBar.Component;


public class NonResourceNavigatorComponent extends Component {

    private static class NonResourceNavigatorPanel extends AbstractNavigatorPanel {

        @Override
        protected String getAllLinkLabel() {
            return "All Referenced Taxonomies";
        }

    }
    
    private NonResourceNavigatorPanel p;

    public NonResourceNavigatorComponent() {
        super("Referenced Taxonomies");
        p = new NonResourceNavigatorPanel();
        setWidget(p);
        ClientModelManager.INSTANCE.getClassesInGroup(EIOntConstants.CG_NON_RESOURCE_ROOT, new ClassesInGroupCallback() {

            @Override
            public void onSuccess(List<EIClass> result) {
                p.setRootClasses(result);
            }
        });
    }

    public void setClass(EIClass clazz) {
        p.setClass(clazz);
    }
    
}
