package org.eaglei.model.webapp.client;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;
import org.eaglei.model.webapp.client.SideBar.Component;

public class ResourceNavigatorComponent extends Component {

    private static class ResourceNavigatorPanel extends AbstractNavigatorPanel {

        @Override
        protected String getAllLinkLabel() {
            return "All Resource Types";
        }
    }

    private ResourceNavigatorPanel p;

    public ResourceNavigatorComponent() {
        super("Resource Types");
        p = new ResourceNavigatorPanel();
        setWidget(p);
        ClientModelManager.INSTANCE.getClassesInGroup(EIOntConstants.CG_RESOURCE_ROOT, new ClassesInGroupCallback() {

            @Override
            public void onSuccess(final List<EIClass> rootResources) {
                ClientModelManager.INSTANCE.getClassesInGroup(EIOntConstants.CG_EMBEDDED_CLASS, new ClassesInGroupCallback() {

                    @Override
                    public void onSuccess(List<EIClass> embeddedResources) {
                        List<EIClass> rootExcludingEmbedded = new ArrayList<EIClass>(rootResources.size());
                        for (EIClass r : rootResources) {
                            if (!embeddedResources.contains(r)) {
                                rootExcludingEmbedded.add(r);
                            }
                        }
                        p.setRootClasses(rootExcludingEmbedded);
                    }
                });
            }
        });
    }

    public void setClass(EIClass clazz) {
        p.setClass(clazz);
    }
    
}
