/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.AFun;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.MultiListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNF {
    public static ATermAppl dnf(ATermAppl term) {
        return DNF.dnfFromNnf(ATermUtils.nnf(term));
    }

    private static ATermAppl dnfFromNnf(ATermAppl term) {
        ATermAppl dnf;
        AFun fun = term.getAFun();
        if (ATermUtils.ANDFUN.equals(fun)) {
            ATermList rootConjuncts = (ATermList)term.getArgument(0);
            ArrayList<ATermAppl> conjuncts = new ArrayList<ATermAppl>();
            MultiListIterator i = new MultiListIterator(rootConjuncts);
            while (i.hasNext()) {
                ATermAppl a = i.next();
                if (ATermUtils.isAnd(a)) {
                    i.append((ATermList)a.getArgument(0));
                    continue;
                }
                ATermAppl dnfA = DNF.dnfFromNnf(a);
                conjuncts.add(dnfA);
            }
            ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
            for (ATermAppl a : conjuncts) {
                if (disjuncts.isEmpty()) {
                    DNF.addToList(a, ATermUtils.isOr(a), disjuncts);
                    continue;
                }
                ArrayList<ATermAppl> thisArgs = new ArrayList<ATermAppl>();
                ArrayList<ATermAppl> newDisjuncts = new ArrayList<ATermAppl>();
                DNF.addToList(a, ATermUtils.isOr(a), thisArgs);
                for (ATermAppl a1 : thisArgs) {
                    for (ATermAppl b : disjuncts) {
                        ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
                        DNF.addToList(a1, ATermUtils.isAnd(a1), list);
                        DNF.addToList(b, ATermUtils.isAnd(b), list);
                        newDisjuncts.add(ATermUtils.makeAnd(ATermUtils.toSet(list)));
                    }
                }
                disjuncts = newDisjuncts;
            }
            dnf = ATermUtils.makeOr(ATermUtils.toSet(disjuncts));
        } else if (ATermUtils.ORFUN.equals(fun)) {
            ATermList disjuncts = (ATermList)term.getArgument(0);
            MultiListIterator i = new MultiListIterator(disjuncts);
            ArrayList<ATermAppl> args = new ArrayList<ATermAppl>();
            while (i.hasNext()) {
                ATermAppl a = i.next();
                if (ATermUtils.isOr(a)) {
                    i.append((ATermList)a.getArgument(0));
                    continue;
                }
                args.add(DNF.dnfFromNnf(a));
            }
            dnf = ATermUtils.makeOr(ATermUtils.toSet(args));
        } else {
            dnf = term;
        }
        return dnf;
    }

    private static void addToList(ATermAppl term, boolean flatten, List<ATermAppl> result) {
        if (flatten) {
            ATermList l = (ATermList)term.getArgument(0);
            while (!l.isEmpty()) {
                result.add((ATermAppl)l.getFirst());
                l = l.getNext();
            }
        } else {
            result.add(term);
        }
    }
}

