/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import com.clarkparsia.pellet.rules.AllNamedIndividualsIterator;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.LiteralFilter;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatavaluePropertyBindingHelper
implements BindingHelper {
    private ABox abox;
    private VariableBinding binding;
    private Literal object;
    private Iterator<Literal> objectIterator;
    private DatavaluedPropertyAtom pattern;
    private Role role;
    private Individual subject;
    private Iterator<Individual> subjectIterator;

    public DatavaluePropertyBindingHelper(ABox abox, DatavaluedPropertyAtom pattern) {
        this.abox = abox;
        this.pattern = pattern;
    }

    public Collection<AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
        return VariableUtils.getVars(this.pattern);
    }

    private Literal getObject() {
        return this.binding.get((AtomDObject)this.pattern.getArgument2());
    }

    public Collection<AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return Collections.emptySet();
    }

    private Role getRole() {
        if (this.role == null) {
            this.role = this.abox.getRole((ATerm)this.pattern.getPredicate());
        }
        return this.role;
    }

    private Individual getSubject() {
        return this.binding.get((AtomIObject)this.pattern.getArgument1());
    }

    private boolean isObjectSet() {
        return this.binding.get((AtomDObject)this.pattern.getArgument2()) != null;
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        this.binding = new VariableBinding(newBinding);
        this.subjectIterator = this.getSubject() != null ? Collections.singleton(this.getSubject()).iterator() : new AllNamedIndividualsIterator(this.abox);
    }

    @Override
    public boolean selectNextBinding() {
        if (this.binding == null) {
            return false;
        }
        while (true) {
            if (this.subject == null || this.isObjectSet()) {
                if (!this.subjectIterator.hasNext()) {
                    return false;
                }
                this.subject = this.subjectIterator.next();
                if (!this.isObjectSet()) {
                    this.objectIterator = new LiteralFilter(this.subject.getRNeighbors(this.getRole()).iterator());
                }
            }
            if (this.isObjectSet()) {
                boolean result = this.subject.getRNeighbors(this.getRole()).contains(this.getObject());
                if (!result) continue;
                return true;
            }
            if (this.objectIterator.hasNext()) {
                this.object = this.objectIterator.next();
                return true;
            }
            this.subject = null;
        }
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
        currentBinding.set((AtomIObject)this.pattern.getArgument1(), this.subject);
        currentBinding.set((AtomDObject)this.pattern.getArgument2(), this.object);
    }

    public String toString() {
        return "edges(" + this.pattern + ")";
    }
}

