/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericComparisonVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FunctionApplicationVisitor
implements NumericVisitor {
    NumericFunction function;
    Number result;

    public FunctionApplicationVisitor(NumericFunction function) {
        this(function, null);
    }

    public FunctionApplicationVisitor(NumericFunction function, Number expected) {
        this.function = function;
        this.result = expected;
    }

    public Number getResult() {
        return this.result;
    }

    private void testAndSetResult(Number theResult) {
        if (this.result == null) {
            this.result = theResult;
        } else {
            NumericComparisonVisitor visitor = new NumericComparisonVisitor();
            NumericPromotion promoter = new NumericPromotion();
            promoter.promote(this.result, theResult);
            promoter.accept(visitor);
            this.result = visitor.getComparison() == 0 ? theResult : null;
        }
    }

    public void visit(BigDecimal[] args) {
        this.testAndSetResult(this.function.apply(args));
    }

    public void visit(BigInteger[] args) {
        this.testAndSetResult(this.function.apply(args));
    }

    public void visit(Double[] args) {
        this.testAndSetResult(this.function.apply(args));
    }

    public void visit(Float[] args) {
        this.testAndSetResult(this.function.apply(args));
    }
}

