/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class GeneralFunctionBuiltIn
implements BuiltIn {
    private GeneralFunction function;

    public GeneralFunctionBuiltIn(GeneralFunction function) {
        this.function = function;
    }

    public BindingHelper createHelper(BuiltInAtom atom) {
        return new GeneralFunctionHelper(atom);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GeneralFunctionHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private VariableBinding partial;
        private boolean used;

        public GeneralFunctionHelper(BuiltInAtom atom) {
            this.atom = atom;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            if (!this.isApplicable(bound)) {
                return Collections.emptySet();
            }
            return SetUtils.difference(VariableUtils.getVars(this.atom), bound);
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            Collection<AtomVariable> vars = VariableUtils.getVars(this.atom);
            vars.removeAll(this.getBindableVars(bound));
            return vars;
        }

        private boolean isApplicable(Collection<AtomVariable> bound) {
            boolean[] boundPositions = new boolean[this.atom.getAllArguments().size()];
            for (int i = 0; i < boundPositions.length; ++i) {
                boundPositions[i] = bound.contains(this.atom.getAllArguments().get(i));
            }
            return GeneralFunctionBuiltIn.this.function.isApplicable(boundPositions);
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            Object[] arguments = new Literal[this.atom.getAllArguments().size()];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = newBinding.get((AtomDObject)this.atom.getAllArguments().get(i));
            }
            if (GeneralFunctionBuiltIn.this.function.apply(newBinding.getABox(), (Literal[])arguments)) {
                VariableBinding newPartial = new VariableBinding(newBinding.getABox());
                for (int i = 0; i < arguments.length; ++i) {
                    AtomDObject arg = (AtomDObject)this.atom.getAllArguments().get(i);
                    Object result = arguments[i];
                    Literal current = newBinding.get(arg);
                    if (current != null && !current.equals(result)) {
                        if (newBinding.get(arg) != null) {
                            throw new InternalReasonerException("General Function implementation overwrote one of its arguments!");
                        }
                        ABox.log.info("Function results in multiple simultaneous values for variable");
                        return;
                    }
                    if (current != null) continue;
                    newBinding.set(arg, (Literal)result);
                }
                this.used = false;
                this.partial = newPartial;
            } else {
                System.out.println("Function failure: " + this.atom);
                System.out.println("Arguments: " + Arrays.toString(arguments));
            }
        }

        @Override
        public boolean selectNextBinding() {
            if (this.partial != null && !this.used) {
                this.used = true;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
            for (Map.Entry<AtomDVariable, Literal> entry : this.partial.dataEntrySet()) {
                currentBinding.set((AtomDObject)entry.getKey(), entry.getValue());
            }
        }
    }
}

