/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.util.EmptyNamespaceContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWrappingWriter
implements XMLStreamWriter2 {
    protected final WriterConfig mConfig;
    protected final boolean mNsAware;
    protected final boolean mNsRepairing;
    protected String mEncoding = null;
    protected NamespaceContext mNsContext;
    protected final Document mDocument;
    protected Element mParentElem;
    protected Element mOpenElement;

    private DOMWrappingWriter(WriterConfig cfg, Node treeRoot) throws XMLStreamException {
        if (treeRoot == null) {
            throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamWriter");
        }
        this.mConfig = cfg;
        this.mNsAware = cfg.willSupportNamespaces();
        boolean bl = this.mNsRepairing = this.mNsAware && cfg.automaticNamespacesEnabled();
        if (this.mNsRepairing) {
            throw new XMLStreamException("Repairing mode not (yet) supported with DOM-backed writer");
        }
        Element elem = null;
        switch (treeRoot.getNodeType()) {
            case 9: {
                this.mDocument = (Document)treeRoot;
                break;
            }
            case 1: {
                this.mDocument = treeRoot.getOwnerDocument();
                elem = (Element)treeRoot;
                break;
            }
            case 11: {
                this.mDocument = treeRoot.getOwnerDocument();
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + treeRoot.getClass());
            }
        }
        if (this.mDocument == null) {
            throw new XMLStreamException("Can not create an XMLStreamWriter for given node (of type " + treeRoot.getClass() + "): did not have owner document");
        }
        this.mParentElem = this.mOpenElement = elem;
    }

    public static DOMWrappingWriter createFrom(WriterConfig cfg, DOMResult dst) throws XMLStreamException {
        Node rootNode = dst.getNode();
        return new DOMWrappingWriter(cfg, rootNode);
    }

    public void close() {
    }

    public void flush() {
    }

    public NamespaceContext getNamespaceContext() {
        if (!this.mNsAware) {
            return EmptyNamespaceContext.getInstance();
        }
        return this.mNsContext;
    }

    public String getPrefix(String uri) {
        if (!this.mNsAware) {
            return null;
        }
        return null;
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setDefaultNamespace(String uri) {
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.mNsContext = context;
    }

    public void setPrefix(String prefix, String uri) {
    }

    public void writeAttribute(String localName, String value) {
        this.outputAttribute(null, null, localName, value);
    }

    public void writeAttribute(String nsURI, String localName, String value) {
        this.outputAttribute(nsURI, null, localName, value);
    }

    public void writeAttribute(String prefix, String nsURI, String localName, String value) {
        this.outputAttribute(nsURI, prefix, localName, value);
    }

    public void writeCData(String data) {
        this.appendLeaf(this.mDocument.createCDATASection(data));
    }

    public void writeCharacters(char[] text, int start, int len) {
        this.writeCharacters(new String(text, start, len));
    }

    public void writeCharacters(String text) {
        this.appendLeaf(this.mDocument.createTextNode(text));
    }

    public void writeComment(String data) {
        this.appendLeaf(this.mDocument.createCDATASection(data));
    }

    public void writeDefaultNamespace(String nsURI) {
        this.writeNamespace(null, nsURI);
    }

    public void writeDTD(String dtd) {
        this.reportUnsupported("writeDTD()");
    }

    public void writeEmptyElement(String localName) {
        this.writeEmptyElement(null, localName);
    }

    public void writeEmptyElement(String nsURI, String localName) {
        this.createStartElem(nsURI, null, localName, true);
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) {
        this.createStartElem(nsURI, prefix, localName, true);
    }

    public void writeEndDocument() {
        this.mOpenElement = null;
        this.mParentElem = null;
    }

    public void writeEndElement() {
        if (this.mParentElem == null) {
            throw new IllegalStateException("No open start element to close");
        }
        this.mOpenElement = null;
        Node parent = this.mParentElem.getParentNode();
        this.mParentElem = parent == this.mDocument ? null : (Element)parent;
    }

    public void writeEntityRef(String name) {
        this.appendLeaf(this.mDocument.createEntityReference(name));
    }

    public void writeNamespace(String prefix, String nsURI) {
        boolean defNS;
        boolean bl = defNS = prefix == null || prefix.length() == 0;
        if (!this.mNsAware) {
            if (defNS) {
                this.outputAttribute(null, null, "xmlns", nsURI);
            } else {
                this.outputAttribute(null, "xmlns", prefix, nsURI);
            }
        } else if (defNS) {
            this.outputAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", nsURI);
        } else {
            this.outputAttribute("http://www.w3.org/2000/xmlns/", "xmlns", prefix, nsURI);
        }
    }

    public void writeProcessingInstruction(String target) {
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data) {
        this.appendLeaf(this.mDocument.createProcessingInstruction(target, data));
    }

    public void writeSpace(char[] text, int start, int len) {
        this.writeSpace(new String(text, start, len));
    }

    public void writeSpace(String text) {
        this.writeCharacters(text);
    }

    public void writeStartDocument() {
        this.writeStartDocument("UTF-8", "1.0");
    }

    public void writeStartDocument(String version2) {
        this.writeStartDocument(null, version2);
    }

    public void writeStartDocument(String encoding, String version2) {
        this.mEncoding = encoding;
    }

    public void writeStartElement(String localName) {
        this.writeStartElement(null, localName);
    }

    public void writeStartElement(String nsURI, String localName) {
        this.createStartElem(nsURI, null, localName, false);
    }

    public void writeStartElement(String prefix, String localName, String nsURI) {
        this.createStartElem(nsURI, prefix, localName, false);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public boolean setProperty(String name, Object value) {
        return this.mConfig.setProperty(name, value);
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    public XMLStreamLocation2 getLocation() {
        return null;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void writeCData(char[] text, int start, int len) throws XMLStreamException {
        this.writeCData(new String(text, start, len));
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        if (this.mParentElem != null) {
            throw new IllegalStateException("Operation only allowed to the document before adding root element");
        }
        this.reportUnsupported("writeDTD()");
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.writeEndElement();
    }

    public void writeStartDocument(String version2, String encoding, boolean standAlone) throws XMLStreamException {
        this.writeStartDocument(encoding, version2);
    }

    public void writeRaw(String text) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void writeRaw(String text, int start, int offset) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void copyEventFromReader(XMLStreamReader2 r, boolean preserveEventData) throws XMLStreamException {
    }

    protected void appendLeaf(Node n) throws IllegalStateException {
        if (this.mParentElem == null) {
            this.mDocument.appendChild(n);
        } else {
            this.mOpenElement = null;
            this.mParentElem.appendChild(n);
        }
    }

    protected void createStartElem(String nsURI, String prefix, String localName, boolean isEmpty) {
        Element elem;
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                // empty if block
            }
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            elem = this.mDocument.createElementNS(nsURI, localName);
        } else {
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            elem = this.mDocument.createElement(localName);
        }
        this.appendLeaf(elem);
        this.mOpenElement = elem;
        if (!isEmpty) {
            this.mParentElem = elem;
        }
    }

    protected void outputAttribute(String nsURI, String prefix, String localName, String value) {
        if (this.mOpenElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                // empty if block
            }
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            this.mOpenElement.setAttributeNS(nsURI, localName, value);
        } else {
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            this.mOpenElement.setAttribute(localName, value);
        }
    }

    private void reportUnsupported(String operName) {
        throw new UnsupportedOperationException(operName + " can not be used with DOM-backed writer");
    }
}

