/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.resultset.OutputBase;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.StrUtils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CSVOutput
extends OutputBase {
    static String NL = "\r\n";
    static final byte[] yesBytes = StrUtils.asUTF8bytes("yes");
    static final byte[] noBytes = StrUtils.asUTF8bytes("no");
    static final byte[] NLBytes = StrUtils.asUTF8bytes(NL);

    public void format(OutputStream out, ResultSet resultSet) {
        try {
            Object ps = null;
            Writer w = FileUtils.asUTF8(out);
            w = new BufferedWriter(w);
            String sep = null;
            List<String> varNames = resultSet.getResultVars();
            ArrayList<Var> vars = new ArrayList<Var>(varNames.size());
            for (String v : varNames) {
                if (sep != null) {
                    w.write(sep);
                } else {
                    sep = ",";
                }
                w.write("?");
                w.write(v);
                vars.add(Var.alloc(v));
            }
            w.write(NL);
            while (resultSet.hasNext()) {
                sep = null;
                Binding b = resultSet.nextBinding();
                for (Var v : vars) {
                    if (sep != null) {
                        w.write(sep);
                    }
                    sep = ",";
                    Node n = b.get(v);
                    if (n == null) continue;
                    String str2 = FmtUtils.stringForNode(n);
                    str2 = this.csvSafe(str2);
                    w.write(str2);
                }
                w.write(NL);
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }

    private String csvSafe(String str2) {
        return str2;
    }

    public void format(OutputStream out, boolean booleanResult) {
        try {
            if (booleanResult) {
                out.write(yesBytes);
            } else {
                out.write(noBytes);
            }
            out.write(NLBytes);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }
}

