/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler;

import java.util.Collection;
import java.util.HashSet;
import jjtraveler.All;
import jjtraveler.Backtrack;
import jjtraveler.BottomUp;
import jjtraveler.BreadthFirst;
import jjtraveler.Choice;
import jjtraveler.Collector;
import jjtraveler.DefUse;
import jjtraveler.DownUp;
import jjtraveler.Event;
import jjtraveler.Fail;
import jjtraveler.Identity;
import jjtraveler.LibraryTest;
import jjtraveler.LogVisitor;
import jjtraveler.Logger;
import jjtraveler.Node;
import jjtraveler.Not;
import jjtraveler.Sequence;
import jjtraveler.StateVisitor;
import jjtraveler.TopDown;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import junit.framework.Assert;
import junit.framework.TestCase;

public class LibraryTest
extends TestCase {
    Node n0;
    Node n1;
    Node n2;
    Node n3;
    Node n4;
    Logger logger;

    public LibraryTest(String test) {
        super(test);
    }

    protected void setUp() {
        Node.reset();
        Node[] empty = new Node[]{};
        this.logger = new Logger();
        this.n0 = Node.factory(empty);
        this.n1 = Node.factory(empty);
        this.n2 = Node.factory(empty);
        this.n3 = Node.factory(new Node[]{this.n0, this.n1});
        this.n4 = Node.factory(new Node[]{this.n3, this.n2});
    }

    public void testSequence() throws VisitFailure {
        Identity id1 = new Identity();
        Identity id2 = new Identity();
        Logger expected = new Logger();
        expected.log(new Event(id1, this.n0));
        expected.log(new Event(id2, this.n0));
        Sequence ls = new Sequence(this.logVisitor(id1), this.logVisitor(id2));
        Visitable nodeReturned = ls.visit(this.n0);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)nodeReturned, (Object)this.n0);
    }

    public void testLeftChoice() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n0});
        Choice ch = new Choice(this.logVisitor(id), new Identity());
        Visitable nodeReturned = ch.visit(this.n0);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n0, (Object)nodeReturned);
    }

    public void testRightChoice() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n0});
        Choice ch = new Choice(new Fail(), this.logVisitor(id));
        Visitable nodeReturned = ch.visit(this.n0);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n0, (Object)nodeReturned);
    }

    public void testAll() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n3, this.n2});
        All all = new All(this.logVisitor(id));
        Visitable nodeReturned = all.visit(this.n4);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n4, (Object)nodeReturned);
    }

    public void testBottomUp() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n0, this.n1, this.n3, this.n2, this.n4});
        BottomUp visitor = new BottomUp(this.logVisitor(id));
        Visitable nodeReturned = visitor.visit(this.n4);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n4, (Object)nodeReturned);
    }

    public void testTopDown() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n4, this.n3, this.n0, this.n1, this.n2});
        TopDown visitor = new TopDown(this.logVisitor(id));
        Visitable nodeReturned = visitor.visit(this.n4);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n4, (Object)nodeReturned);
    }

    public void testDownUp() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n4, this.n3, this.n0, this.n0, this.n1, this.n1, this.n3, this.n2, this.n2, this.n4});
        DownUp visitor = new DownUp(this.logVisitor(id), this.logVisitor(id));
        Visitable nodeReturned = visitor.visit(this.n4);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n4, (Object)nodeReturned);
    }

    public void testNonStopDownUp() throws VisitFailure {
        Identity downId = new Identity();
        Identity upId = new Identity();
        Fail stop = new Fail();
        Logger expected = new Logger();
        expected.log(new Event(downId, this.n3));
        expected.log(new Event(downId, this.n0));
        expected.log(new Event(upId, this.n0));
        expected.log(new Event(downId, this.n1));
        expected.log(new Event(upId, this.n1));
        expected.log(new Event(upId, this.n3));
        DownUp visitor = new DownUp(this.logVisitor(downId), stop, this.logVisitor(upId));
        Visitable nodeReturned = visitor.visit(this.n3);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n3, (Object)nodeReturned);
    }

    public void testStopDownUp() throws VisitFailure {
        Identity downId = new Identity();
        Identity upId = new Identity();
        Identity stopId = new Identity();
        Logger expected = new Logger();
        expected.log(new Event(downId, this.n4));
        expected.log(new Event(stopId, this.n4));
        expected.log(new Event(upId, this.n4));
        DownUp visitor = new DownUp(this.logVisitor(downId), this.logVisitor(stopId), this.logVisitor(upId));
        Visitable nodeReturned = visitor.visit(this.n4);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)this.n4, (Object)nodeReturned);
    }

    public void testDefUse() throws VisitFailure {
        class Def
        extends Identity
        implements Collector {
            final /* synthetic */ LibraryTest this$0;

            Def(LibraryTest libraryTest) {
                this.this$0 = libraryTest;
            }

            public Collection getCollection() {
                HashSet<String> result = new HashSet<String>();
                result.add("aap");
                result.add("noot");
                return result;
            }
        }
        Def def = new Def(this);
        class Use
        extends Identity
        implements Collector {
            final /* synthetic */ LibraryTest this$0;

            Use(LibraryTest libraryTest) {
                this.this$0 = libraryTest;
            }

            public Collection getCollection() {
                HashSet<String> result = new HashSet<String>();
                result.add("aap");
                result.add("mies");
                return result;
            }
        }
        Use use = new Use(this);
        DefUse du = new DefUse(use, def);
        du.visit(this.n0);
        Assert.assertTrue((boolean)du.getUnused().contains("noot"));
        Assert.assertTrue((boolean)du.getUndefined().contains("mies"));
        Assert.assertEquals((int)1, (int)du.getUnused().size());
        Assert.assertEquals((int)1, (int)du.getUndefined().size());
    }

    public void testBacktrack() throws VisitFailure {
        class Increment
        implements StateVisitor {
            Object localState;
            public int state;
            final /* synthetic */ LibraryTest this$0;

            Increment(LibraryTest libraryTest) {
                this.this$0 = libraryTest;
                this.localState = null;
                this.state = 0;
            }

            public Object getState() {
                return new Integer(this.state);
            }

            public void setState(Object o) {
                this.state = (Integer)o;
            }

            public Visitable visit(Visitable x) {
                ++this.state;
                this.localState = this.getState();
                return x;
            }
        }
        Increment i = new Increment(this);
        Object initialState = i.getState();
        new Backtrack(i).visit(this.n0);
        Assert.assertNotNull((Object)i.localState);
        Assert.assertTrue((!initialState.equals(i.localState) ? 1 : 0) != 0);
        Assert.assertEquals((Object)initialState, (Object)i.getState());
    }

    public LogVisitor logVisitor(Visitor v) {
        return new LogVisitor(v, this.logger);
    }

    public void testBreadthFirst() throws VisitFailure {
        Identity id = new Identity();
        Logger expected = new Logger((Visitor)id, new Visitable[]{this.n4, this.n3, this.n2, this.n0, this.n1});
        BreadthFirst bf = new BreadthFirst(this.logVisitor(id));
        Visitable resultNode = bf.visit(this.n4);
        Assert.assertEquals((Object)expected, (Object)this.logger);
        Assert.assertEquals((Object)resultNode, (Object)this.n4);
    }

    public void testNotOnFailure() throws VisitFailure {
        Not not2 = new Not(new Fail());
        Visitable resultNode = not2.visit(this.n0);
        Assert.assertEquals((Object)this.n0, (Object)resultNode);
    }

    public void testNotOnSuccess() throws VisitFailure {
        Not not2 = new Not(new Identity());
        Visitable resultNode = null;
        try {
            resultNode = not2.visit(this.n0);
            Assert.fail((String)"VisitFailure should have occured");
        }
        catch (VisitFailure f) {
            Assert.assertNull(resultNode);
        }
    }
}

