/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianStemmer;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class RussianStemFilter
extends TokenFilter {
    private RussianStemmer stemmer = new RussianStemmer();
    private TermAttribute termAtt = this.addAttribute(TermAttribute.class);

    public RussianStemFilter(TokenStream in) {
        super(in);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String term = this.termAtt.term();
            String s = this.stemmer.stem(term);
            if (s != null && !s.equals(term)) {
                this.termAtt.setTermBuffer(s);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(RussianStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

