/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = false;
    private int maxBBuf = Constants.JRE_IS_64BIT ? Integer.MAX_VALUE : 0x10000000;
    public static final boolean UNMAP_SUPPORTED;

    public MMapDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public MMapDirectory(File path) throws IOException {
        super(path, null);
    }

    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("Unmap hack not supported on this platform!");
        }
        this.useUnmapHack = useUnmapHack;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    final void cleanMapping(final ByteBuffer buffer) throws IOException {
        if (this.useUnmapHack) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                IOException ioe = new IOException("unable to unmap the mapped buffer");
                ioe.initCause(e2.getCause());
                throw ioe;
            }
        }
    }

    public void setMaxChunkSize(int maxBBuf) {
        if (maxBBuf <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.maxBBuf = maxBBuf;
    }

    public int getMaxChunkSize() {
        return this.maxBBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInput openInput(String name, int bufferSize) throws IOException {
        IndexInput indexInput;
        this.ensureOpen();
        File f = new File(this.getFile(), name);
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        try {
            indexInput = raf.length() <= (long)this.maxBBuf ? new MMapIndexInput(raf) : new MultiMMapIndexInput(raf, this.maxBBuf);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            raf.close();
            throw throwable;
        }
        raf.close();
        return indexInput;
    }

    public IndexOutput createOutput(String name) throws IOException {
        this.initOutput(name);
        return new SimpleFSDirectory.SimpleFSIndexOutput(new File(this.directory, name));
    }

    static {
        boolean v;
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            v = true;
        }
        catch (Exception e2) {
            v = false;
        }
        UNMAP_SUPPORTED = v;
    }

    private class MultiMMapIndexInput
    extends IndexInput {
        private ByteBuffer[] buffers;
        private int[] bufSizes;
        private final long length;
        private int curBufIndex;
        private final int maxBufSize;
        private ByteBuffer curBuf;
        private int curAvail;
        private boolean isClone = false;

        public MultiMMapIndexInput(RandomAccessFile raf, int maxBufSize) throws IOException {
            this.length = raf.length();
            this.maxBufSize = maxBufSize;
            if (maxBufSize <= 0) {
                throw new IllegalArgumentException("Non positive maxBufSize: " + maxBufSize);
            }
            if (this.length / (long)maxBufSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessFile too big for maximum buffer size: " + raf.toString());
            }
            int nrBuffers = (int)(this.length / (long)maxBufSize);
            if ((long)nrBuffers * (long)maxBufSize < this.length) {
                ++nrBuffers;
            }
            this.buffers = new ByteBuffer[nrBuffers];
            this.bufSizes = new int[nrBuffers];
            long bufferStart = 0L;
            FileChannel rafc = raf.getChannel();
            for (int bufNr = 0; bufNr < nrBuffers; ++bufNr) {
                int bufSize = this.length > bufferStart + (long)maxBufSize ? maxBufSize : (int)(this.length - bufferStart);
                this.buffers[bufNr] = rafc.map(FileChannel.MapMode.READ_ONLY, bufferStart, bufSize);
                this.bufSizes[bufNr] = bufSize;
                bufferStart += (long)bufSize;
            }
            this.seek(0L);
        }

        public byte readByte() throws IOException {
            if (this.curAvail == 0) {
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new IOException("read past EOF");
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                this.curAvail = this.bufSizes[this.curBufIndex];
            }
            --this.curAvail;
            return this.curBuf.get();
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            while (len > this.curAvail) {
                this.curBuf.get(b, offset, this.curAvail);
                len -= this.curAvail;
                offset += this.curAvail;
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new IOException("read past EOF");
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                this.curAvail = this.bufSizes[this.curBufIndex];
            }
            this.curBuf.get(b, offset, len);
            this.curAvail -= len;
        }

        public long getFilePointer() {
            return (long)this.curBufIndex * (long)this.maxBufSize + (long)this.curBuf.position();
        }

        public void seek(long pos) throws IOException {
            this.curBufIndex = (int)(pos / (long)this.maxBufSize);
            this.curBuf = this.buffers[this.curBufIndex];
            int bufOffset = (int)(pos - (long)this.curBufIndex * (long)this.maxBufSize);
            this.curBuf.position(bufOffset);
            this.curAvail = this.bufSizes[this.curBufIndex] - bufOffset;
        }

        public long length() {
            return this.length;
        }

        public Object clone() {
            MultiMMapIndexInput clone = (MultiMMapIndexInput)super.clone();
            clone.isClone = true;
            clone.buffers = new ByteBuffer[this.buffers.length];
            for (int bufNr = 0; bufNr < this.buffers.length; ++bufNr) {
                clone.buffers[bufNr] = this.buffers[bufNr].duplicate();
            }
            try {
                clone.seek(this.getFilePointer());
            }
            catch (IOException ioe) {
                RuntimeException newException = new RuntimeException(ioe);
                newException.initCause(ioe);
                throw newException;
            }
            return clone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isClone || this.buffers == null) {
                return;
            }
            try {
                for (int bufNr = 0; bufNr < this.buffers.length; ++bufNr) {
                    Object var3_2;
                    try {
                        MMapDirectory.this.cleanMapping(this.buffers[bufNr]);
                        var3_2 = null;
                        this.buffers[bufNr] = null;
                        continue;
                    }
                    catch (Throwable throwable) {
                        var3_2 = null;
                        this.buffers[bufNr] = null;
                        throw throwable;
                    }
                }
                Object var5_4 = null;
                this.buffers = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.buffers = null;
                throw throwable;
            }
        }
    }

    private class MMapIndexInput
    extends IndexInput {
        private ByteBuffer buffer;
        private final long length;
        private boolean isClone = false;

        private MMapIndexInput(RandomAccessFile raf) throws IOException {
            this.length = raf.length();
            this.buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
        }

        public byte readByte() throws IOException {
            try {
                return this.buffer.get();
            }
            catch (BufferUnderflowException e2) {
                throw new IOException("read past EOF");
            }
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            try {
                this.buffer.get(b, offset, len);
            }
            catch (BufferUnderflowException e2) {
                throw new IOException("read past EOF");
            }
        }

        public long getFilePointer() {
            return this.buffer.position();
        }

        public void seek(long pos) throws IOException {
            this.buffer.position((int)pos);
        }

        public long length() {
            return this.length;
        }

        public Object clone() {
            MMapIndexInput clone = (MMapIndexInput)super.clone();
            clone.isClone = true;
            clone.buffer = this.buffer.duplicate();
            return clone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isClone || this.buffer == null) {
                return;
            }
            try {
                MMapDirectory.this.cleanMapping(this.buffer);
                Object var2_1 = null;
                this.buffer = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.buffer = null;
                throw throwable;
            }
        }
    }
}

