/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.eaglei.lexical.lucene.LuceneEntityExtractionIndexer;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class EIModelLuceneIndexer
extends LuceneEntityExtractionIndexer {
    private static final Log logger = LogFactory.getLog(EIModelLuceneIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private EIOntModel eagleiOntModel;
    private OntModel jenaOntModel;

    public EIModelLuceneIndexer(Analyzer indexAnalyzer, Directory directory, EIOntModel eagleiOntModel, OntModel jenaOntModel) {
        super(indexAnalyzer, directory);
        this.eagleiOntModel = eagleiOntModel;
        this.jenaOntModel = jenaOntModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addDocuments(IndexWriter iwriter) throws IOException {
        this.jenaOntModel.enterCriticalSection(true);
        try {
            List<Property> labelProps = ((JenaEIOntModel)this.eagleiOntModel).getLabelProperties();
            HashSet<String> processedURIs = new HashSet<String>();
            for (EIClass eiClass : this.eagleiOntModel.getTopLevelClasses()) {
                this.processSubTree(eiClass.getEntity().getURI().toString(), this.jenaOntModel, labelProps, iwriter, processedURIs);
            }
            for (EIClass eiClass : this.eagleiOntModel.getNonResourceBaseClasses()) {
                this.processSubTree(eiClass.getEntity().getURI().toString(), this.jenaOntModel, labelProps, iwriter, processedURIs);
            }
        }
        finally {
            this.jenaOntModel.leaveCriticalSection();
        }
    }

    private void processSubTree(String classURI, OntModel ontModel, List<Property> properties, IndexWriter iwriter, Set<String> processedURIs) throws IOException {
        OntClass parentClass = ontModel.getOntClass(classURI);
        List<OntClass> subClasses = parentClass.listSubClasses().toList();
        this.processClass(parentClass, properties, iwriter, processedURIs);
        for (OntClass ontClass : subClasses) {
            this.processClass(ontClass, properties, iwriter, processedURIs);
        }
    }

    private void processClass(OntClass ontClass, List<Property> properties, IndexWriter iwriter, Set<String> processedURIs) throws IOException {
        if (OWL.Nothing.getURI().equals(ontClass.getURI())) {
            return;
        }
        String uri = ontClass.getURI();
        if (uri == null) {
            return;
        }
        if (processedURIs.contains(uri)) {
            return;
        }
        processedURIs.add(uri);
        String prefLabel = this.eagleiOntModel.getPreferredLabel(EIURI.create(uri));
        ArrayList<String> typeURIs = new ArrayList<String>();
        typeURIs.add(uri);
        for (OntClass parent : ontClass.listSuperClasses(false).toList()) {
            if (parent == null || parent.getURI() == null) continue;
            typeURIs.add(parent.getURI());
        }
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> props = new ArrayList<String>();
        for (Property p : properties) {
            JenaEIOntModel cfr_ignored_0 = (JenaEIOntModel)this.eagleiOntModel;
            JenaEIOntModel.getLiteralsForProperty(ontClass, p, props);
        }
        for (String prop : props) {
            labels.add(prop);
        }
        this.updateDocument(uri, prefLabel, labels, typeURIs, iwriter);
    }
}

