/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eaglei.model.EIOntModel;
import org.eaglei.network.actions.SearchProviderOperations;
import org.eaglei.network.actions.SearchProviderQueryAction;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProviderFactory;
import org.eaglei.services.InstitutionRegistry;
import org.spin.tools.Util;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class DummyDataQueryAction
extends SearchProviderQueryAction<SearchRequest, SearchResultSet> {
    private static final Logger log = Logger.getLogger(DummyDataQueryAction.class);
    private static final boolean INFO = log.isInfoEnabled();

    public DummyDataQueryAction() throws IOException {
        this(DummyDataQueryAction.getInstitutionLabel(), DummyDataQueryAction.getInstitutionURI());
    }

    public DummyDataQueryAction(String institutionLabel, String institutionURI) throws IOException {
        super(Serializer.SearchRequestSerializer, Serializer.SearchResultSetSerializer, SearchProviderOperations.invokesQuery(DummyDataQueryAction.createProviderForGeneratedData(institutionLabel, institutionURI)));
    }

    private static SearchProvider createProviderForGeneratedData(String institutionLabel, String institutionURI) throws IOException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("services-config.xml", "jena-model-config.xml");
        InstitutionRegistry institutionRegistry = context.getBean(InstitutionRegistry.class);
        EIOntModel ontModel = context.getBean(EIOntModel.class);
        return LuceneSearchProviderFactory.createProviderForGeneratedData(institutionRegistry, ontModel, DummyDataQueryAction.makeDataGenParams(institutionRegistry, institutionLabel, institutionURI));
    }

    private static String getInstitutionURI() {
        return System.getProperty(PropNames.InstitutionURI.propKey);
    }

    private static String getInstitutionLabel() {
        return System.getProperty(PropNames.InstitutionLabel.propKey);
    }

    private static DataGenParams makeDataGenParams(InstitutionRegistry institutionRegistry, String institutionLabel, String institutionURI) {
        DataGenParams params;
        Util.guardNotNull((Object)institutionRegistry);
        if (institutionLabel != null && institutionURI != null) {
            if (INFO) {
                log.info("Creating dummy data for '" + institutionLabel + "' (" + institutionURI + ")");
            }
            params = DataGenParams.createForOneInstitution(institutionURI, institutionLabel);
        } else {
            if (INFO) {
                log.info("Creating dummy data for one institution");
            }
            Util.require((institutionRegistry != null ? 1 : 0) != 0);
            params = DataGenParams.createForOneInstitution(institutionRegistry.getInstitutions().get(0));
        }
        params.setMaterializeHierarchy(true);
        return params;
    }

    public static enum PropNames {
        InstitutionURI,
        InstitutionLabel;

        private static final String prefix = "Spin.Eagle-I.Props.DummyData.";
        public final String propKey = "Spin.Eagle-I.Props.DummyData." + this.name();
    }
}

