/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.incremental;

import aterm.ATermAppl;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.incremental.BranchAddDependency;
import org.mindswap.pellet.tableau.completion.incremental.ClashDependency;
import org.mindswap.pellet.tableau.completion.incremental.CloseBranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.DependencyEntry;
import org.mindswap.pellet.tableau.completion.incremental.DependencyIndex;
import org.mindswap.pellet.tableau.completion.incremental.MergeDependency;
import org.mindswap.pellet.tableau.completion.incremental.TypeDependency;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.intset.IntSet;

public class IncrementalRestore {
    private KnowledgeBase kb;

    public static void restoreDependencies(KnowledgeBase kb) {
        IncrementalRestore restore = new IncrementalRestore(kb);
        restore.restoreDependencies();
    }

    private IncrementalRestore(KnowledgeBase kb) {
        this.kb = kb;
    }

    private void restoreBranchAdd(ATermAppl assertion, BranchAddDependency branch) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Removing branch add? " + branch.getBranch());
        }
        DependencySet ds = branch.getBranch().getTermDepends();
        ds.removeExplain(assertion);
        if (ds.getExplain().isEmpty()) {
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removing branch!");
            }
            List<ATermAppl> allEffects = PelletOptions.TRACK_BRANCH_EFFECTS ? this.kb.getABox().getBranchEffectTracker().getAll(branch.getBranch().getBranch()) : this.kb.getABox().getNodeNames();
            ArrayList<IntSet> updatedList = new ArrayList<IntSet>();
            for (ATermAppl a : allEffects) {
                Node node = this.kb.getABox().getNode(a);
                Map<ATermAppl, DependencySet> types = node.getDepends();
                for (Map.Entry<ATermAppl, DependencySet> entry : types.entrySet()) {
                    int i;
                    DependencySet tDS = entry.getValue();
                    boolean exit = false;
                    for (i = 0; i < updatedList.size(); ++i) {
                        if (updatedList.get(i) != tDS.getDepends()) continue;
                        exit = true;
                    }
                    if (exit) continue;
                    updatedList.add(tDS.getDepends());
                    if (tDS.getBranch() > branch.getBranch().getBranch()) {
                        tDS = tDS.copy(tDS.getBranch() - 1);
                    }
                    for (i = branch.getBranch().getBranch(); i <= this.kb.getABox().getBranches().size(); ++i) {
                        if (!tDS.contains(i)) continue;
                        tDS.remove(i);
                        tDS.add(i - 1);
                    }
                    entry.setValue(tDS);
                }
                EdgeList edges = node.getInEdges();
                for (Edge edge : edges) {
                    int i;
                    DependencySet tDS = edge.getDepends();
                    boolean exit = false;
                    for (i = 0; i < updatedList.size(); ++i) {
                        if (updatedList.get(i) != tDS.getDepends()) continue;
                        exit = true;
                    }
                    if (exit) continue;
                    updatedList.add(tDS.getDepends());
                    if (tDS.getBranch() > branch.getBranch().getBranch()) {
                        tDS = tDS.copy(edge.getDepends().getBranch() - 1);
                    }
                    for (i = branch.getBranch().getBranch(); i <= this.kb.getABox().getBranches().size(); ++i) {
                        if (!tDS.contains(i)) continue;
                        tDS.remove(i);
                        tDS.add(i - 1);
                    }
                    edge.setDepends(tDS);
                }
            }
            if (PelletOptions.TRACK_BRANCH_EFFECTS) {
                this.kb.getABox().getBranchEffectTracker().remove(branch.getBranch().getBranch() + 1);
            }
            List<Branch> branches = this.kb.getABox().getBranches();
            for (int i = branch.getBranch().getBranch(); i < branches.size(); ++i) {
                Branch br = branches.get(i);
                DependencySet tDS = br.getTermDepends();
                if (tDS.getBranch() > branch.getBranch().getBranch()) {
                    tDS = tDS.copy(tDS.getBranch() - 1);
                }
                for (int j = branch.getBranch().getBranch(); j < this.kb.getABox().getBranches().size(); ++j) {
                    if (!tDS.contains(j)) continue;
                    tDS.remove(j);
                    tDS.add(j - 1);
                }
                br.setBranch(br.getBranch() - 1);
                br.setTermDepends(tDS);
            }
            branches.remove(branch.getBranch());
            this.kb.getABox().setBranch(this.kb.getABox().getBranch() - 1);
        }
    }

    private void restoreClash(ATermAppl assertion, ClashDependency clash) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Restoring clash dependency clash: " + clash.getClash());
        }
        clash.getClash().getDepends().removeExplain(assertion);
        if (clash.getClash().getDepends().getExplain().isEmpty() && clash.getClash().getDepends().isIndependent()) {
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removing clash!");
            }
            this.kb.getABox().setClash(null);
        }
    }

    private void restoreCloseBranch(ATermAppl assertion, CloseBranchDependency branch) {
        if (branch.getTheBranch().getTryNext() > -1) {
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("    Undoing branch remove - branch " + branch.getBranch() + "  -  " + branch.getInd() + "   tryNext: " + branch.getTryNext());
            }
            branch.getTheBranch().shiftTryNext(branch.getTryNext());
        }
    }

    private void restoreDependencies() {
        for (ATermAppl next : this.kb.getDeletedAssertions()) {
            DependencyEntry entry = this.kb.getDependencyIndex().getDependencies(next);
            if (entry != null) {
                if (DependencyIndex.log.isLoggable(Level.FINE)) {
                    DependencyIndex.log.fine("Restoring dependencies for " + next);
                }
                this.restoreDependency(next, entry);
            }
            this.kb.getDependencyIndex().removeDependencies(next);
        }
    }

    private void restoreDependency(ATermAppl assertion, DependencyEntry entry) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Edge Dependencies:");
        }
        for (Edge edge : entry.getEdges()) {
            this.restoreEdge(assertion, edge);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Type Dependencies:");
        }
        for (TypeDependency typeDependency : entry.getTypes()) {
            this.restoreType(assertion, typeDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Merge Dependencies: " + entry.getMerges());
        }
        for (MergeDependency mergeDependency : entry.getMerges()) {
            this.restoreMerge(assertion, mergeDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Branch Add Dependencies: " + entry.getBranchAdds());
        }
        for (BranchAddDependency branchAddDependency : entry.getBranchAdds()) {
            this.restoreBranchAdd(assertion, branchAddDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Branch Remove DS Dependencies: " + entry.getBranchAdds());
        }
        for (CloseBranchDependency closeBranchDependency : entry.getCloseBranches()) {
            this.restoreCloseBranch(assertion, closeBranchDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring clash dependency: " + entry.getClash());
        }
        if (entry.getClash() != null) {
            this.restoreClash(assertion, entry.getClash());
        }
    }

    private void restoreEdge(ATermAppl assertion, Edge theEdge) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Removing edge? " + theEdge);
        }
        if (theEdge == null) {
            return;
        }
        Individual subj = this.kb.getABox().getIndividual(theEdge.getFrom().getName());
        Node obj = this.kb.getABox().getNode(theEdge.getTo().getName());
        Role role = this.kb.getRole(theEdge.getRole().getName());
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            if (!edge.getRole().equals(role)) continue;
            DependencySet ds = edge.getDepends();
            ds.removeExplain(assertion);
            if (!ds.getExplain().isEmpty()) break;
            IncrementalChangeTracker tracker = this.kb.getABox().getIncrementalChangeTracker();
            subj.removeEdge(edge);
            obj.removeInEdge(edge);
            tracker.addDeletedEdge(edge);
            tracker.addUpdatedIndividual(subj);
            if (obj instanceof Individual) {
                tracker.addUpdatedIndividual((Individual)obj);
            }
            if (!DependencyIndex.log.isLoggable(Level.FINE)) break;
            DependencyIndex.log.fine("           Actually removed edge!");
            break;
        }
    }

    private void restoreMerge(ATermAppl assertion, MergeDependency merge) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Removing merge? " + merge.getInd() + " merged to " + merge.getmergedIntoInd());
        }
        DependencySet ds = this.kb.getABox().getNode(merge.getInd()).getMergeDependency(false);
        ds.removeExplain(assertion);
        if (ds.getExplain().isEmpty()) {
            Node mergedToInd;
            Node ind;
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removing merge!");
            }
            if (!(ind = this.kb.getABox().getNode(merge.getInd())).isSame(mergedToInd = this.kb.getABox().getNode(merge.getmergedIntoInd()))) {
                throw new InternalReasonerException(" Restore merge error: " + ind + " not same as " + mergedToInd);
            }
            if (!ind.isPruned()) {
                throw new InternalReasonerException(" Restore merge error: " + ind + " not pruned");
            }
            ind.unprune(ind.getPruned().getBranch());
            ind.undoSetSame();
            IncrementalChangeTracker tracker = this.kb.getABox().getIncrementalChangeTracker();
            tracker.addUnprunedNode(ind);
            if (ind instanceof Individual) {
                tracker.addUpdatedIndividual((Individual)ind);
            }
            if (mergedToInd instanceof Individual) {
                tracker.addUpdatedIndividual((Individual)mergedToInd);
            }
        }
    }

    private void restoreType(ATermAppl assertion, TypeDependency type) {
        DependencySet ds;
        Node node = this.kb.getABox().getNode(type.getInd());
        ATermAppl desc = type.getType();
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            if (node instanceof Individual) {
                DependencyIndex.log.fine("    Removing type? " + desc + " from " + ((Individual)node).debugString());
            } else {
                DependencyIndex.log.fine("    Removing type? " + desc + " from " + node);
            }
        }
        if ((ds = node.getDepends(ATermUtils.normalize(desc))) == null || desc == ATermUtils.TOP) {
            return;
        }
        ds.removeExplain(assertion);
        if (ds.getExplain().isEmpty()) {
            IncrementalChangeTracker tracker = this.kb.getABox().getIncrementalChangeTracker();
            this.kb.getABox().removeType(node.getName(), desc);
            tracker.addDeletedType(node, type.getType());
            if (node instanceof Individual) {
                Individual ind = (Individual)node;
                tracker.addUpdatedIndividual(ind);
                for (Edge e2 : ind.getInEdges()) {
                    tracker.addUpdatedIndividual(e2.getFrom());
                }
                for (Edge e2 : ind.getOutEdges()) {
                    if (!(e2.getTo() instanceof Individual)) continue;
                    tracker.addUpdatedIndividual((Individual)e2.getTo());
                }
            }
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removed type!");
            }
        }
    }
}

