/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.coode.owl.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.io.StreamOutputTarget;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyStorageException;
import org.semanticweb.owl.model.UnknownOWLOntologyException;
import org.xml.sax.SAXException;

public class RDFModelWriter {
    private static final String ANON_URI = "#anon";
    private static final URI TMP_URI = URI.create("tag:clarkparsia.com,2008:pellint:tmp");

    private static String toString(RDFNode v) {
        if (v.isLiteral()) {
            return ((Literal)v).getLexicalForm();
        }
        if (v.isAnon()) {
            return ANON_URI + v.asNode().getBlankNodeLabel();
        }
        return ((Resource)v).getURI();
    }

    private static OWLOntology convert(RDFModel model, OWLOntologyManager manager) throws OWLOntologyCreationException, SAXException {
        OWLOntology ontology = manager.createOntology(TMP_URI);
        OWLRDFConsumer consumer = new OWLRDFConsumer(manager, ontology, new AnonymousNodeChecker(){

            public boolean isAnonymousNode(URI uri) {
                return this.isAnonymousNode(uri.toString());
            }

            public boolean isAnonymousNode(String uri) {
                return uri.startsWith(RDFModelWriter.ANON_URI);
            }
        });
        consumer.startModel("");
        for (Statement stmt : model.getStatements()) {
            String subj = RDFModelWriter.toString(stmt.getSubject());
            String pred = RDFModelWriter.toString(stmt.getPredicate());
            RDFNode vObj = stmt.getObject();
            String obj = RDFModelWriter.toString(vObj);
            if (vObj instanceof Literal) {
                Literal literal = (Literal)vObj;
                String datatypeURI = literal.getDatatypeURI();
                String lang = literal.getLanguage();
                if (lang != null && lang.length() == 0) {
                    lang = null;
                }
                consumer.statementWithLiteralValue(subj, pred, obj, lang, datatypeURI);
                continue;
            }
            consumer.statementWithResourceValue(subj, pred, obj);
        }
        consumer.endModel();
        return ontology;
    }

    public void writePretty(OutputStream out, RDFModel model) throws IOException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = null;
        try {
            ontology = RDFModelWriter.convert(model, manager);
        }
        catch (OWLOntologyCreationException e2) {
            throw new RuntimeException(e2);
        }
        catch (SAXException e3) {
            throw new RuntimeException(e3);
        }
        try {
            manager.saveOntology(ontology, (OWLOntologyOutputTarget)new StreamOutputTarget(out));
        }
        catch (UnknownOWLOntologyException e4) {
            throw new RuntimeException(e4);
        }
        catch (OWLOntologyStorageException e5) {
            throw new IOException(e5.getMessage());
        }
    }

    public void write(OutputStream out, RDFModel m) {
        Model model = ModelFactory.createDefaultModel();
        for (Statement stmt : m.getStatements()) {
            model.add(stmt);
        }
        model.write(out);
    }
}

