/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.impl.Location;
import java.lang.reflect.Field;
import org.xml.sax.SAXParseException;

public class ParseException
extends SAXParseException
implements ARPErrorNumbers {
    private static final long serialVersionUID = -5986976549492477885L;
    final int id;
    private boolean promoteMe;

    protected ParseException(int id, Location where, String msg) {
        super(msg, where.inputName, null, where.endLine, where.endColumn);
        this.id = id;
    }

    public ParseException(int id, Location where, Exception e2) {
        super(e2.getMessage(), where.inputName, null, where.endLine, where.endColumn, e2);
        if (this.getCause() == null) {
            this.initCause(e2);
        }
        this.id = id;
    }

    public int getErrorNumber() {
        return this.id;
    }

    public boolean isSyntaxError() {
        switch (this.id) {
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: {
                return true;
            }
        }
        return false;
    }

    SAXParseException rootCause() {
        Exception e2 = this.getException();
        return e2 == null ? this : (SAXParseException)e2;
    }

    public void promote() {
        this.promoteMe = true;
    }

    public String getMessage() {
        String idStr = this.id != 0 ? "{" + (this.id < 200 ? "W" : "E") + ("" + (1000 + this.id)).substring(1) + "} " : "";
        return idStr + super.getMessage();
    }

    public static String formatMessage(Exception e2) {
        String rslt;
        String msg = e2.getMessage();
        if (msg == null) {
            msg = e2.toString();
        }
        if (!(e2 instanceof SAXParseException)) {
            return msg;
        }
        SAXParseException sax = (SAXParseException)e2;
        String file = sax.getSystemId();
        if (file == null) {
            file = sax.getPublicId();
        }
        String string = rslt = file == null ? "" : file;
        if (sax.getLineNumber() == -1) {
            return (file != null ? file + ": " : "") + msg;
        }
        if (sax.getColumnNumber() == -1) {
            return rslt + "(line " + sax.getLineNumber() + "): " + msg;
        }
        return rslt + "(line " + sax.getLineNumber() + " column " + sax.getColumnNumber() + "): " + msg;
    }

    public boolean isPromoted() {
        return this.promoteMe;
    }

    public static String errorCodeName(int errNo) {
        Class<ARPErrorNumbers> c = ARPErrorNumbers.class;
        Field[] flds = c.getDeclaredFields();
        for (int i = 0; i < flds.length; ++i) {
            try {
                if (flds[i].getInt(null) != errNo) continue;
                return flds[i].getName();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return null;
    }

    public static int errorCode(String upper) {
        Class<ARPErrorNumbers> c = ARPErrorNumbers.class;
        try {
            Field fld = c.getField(upper);
            return fld.getInt(null);
        }
        catch (Exception e2) {
            return -1;
        }
    }
}

