/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.StringInterner;

public class SimpleStringInterner
extends StringInterner {
    private final Entry[] cache;
    private final int maxChainLength;

    public SimpleStringInterner(int tableSize, int maxChainLength) {
        this.cache = new Entry[Math.max(1, BitUtil.nextHighestPowerOfTwo(tableSize))];
        this.maxChainLength = Math.max(2, maxChainLength);
    }

    public String intern(String s) {
        int h = s.hashCode();
        int slot = h & this.cache.length - 1;
        Entry first = this.cache[slot];
        Entry nextToLast = null;
        int chainLength = 0;
        Entry e2 = first;
        while (e2 != null) {
            if (e2.hash == h && (e2.str == s || e2.str.compareTo(s) == 0)) {
                return e2.str;
            }
            ++chainLength;
            if (e2.next != null) {
                nextToLast = e2;
            }
            e2 = e2.next;
        }
        s = s.intern();
        this.cache[slot] = new Entry(s, h, first);
        if (chainLength >= this.maxChainLength) {
            nextToLast.next = null;
        }
        return s;
    }

    private static class Entry {
        private final String str;
        private final int hash;
        private Entry next;

        private Entry(String str2, int hash, Entry next) {
            this.str = str2;
            this.hash = hash;
            this.next = next;
        }
    }
}

