/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mindswap.pellet.dig.DIGHandler;
import org.mindswap.pellet.dig.DIGResponse;
import org.mindswap.pellet.dig.ElementList;
import org.mindswap.pellet.utils.ATermUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGTellHandler
extends DIGHandler {
    public Document tells(Element tells) {
        ElementList tellList = DIGTellHandler.getElements(tells);
        for (int i = 0; i < tellList.getLength(); ++i) {
            Element tell = tellList.item(i);
            String tag = tell.getTagName();
            try {
                ElementList list;
                Element elem;
                ElementList pair;
                if (tag.equals("clearKB")) {
                    this.kb.clear();
                    continue;
                }
                if (tag.equals("defconcept")) {
                    this.kb.addClass(DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("defrole")) {
                    this.kb.addObjectProperty(DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("defattribute")) {
                    this.kb.addDatatypeProperty(DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("defindividual")) {
                    this.kb.addIndividual(DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("equalc")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl c1 = this.concept(pair.item(0));
                    ATermAppl c2 = this.concept(pair.item(1));
                    this.kb.addClass(c1);
                    this.kb.addClass(c2);
                    this.kb.addEquivalentClass(c1, c2);
                    continue;
                }
                if (tag.equals("impliesc")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl c1 = this.concept(pair.item(0));
                    ATermAppl c2 = this.concept(pair.item(1));
                    this.kb.addClass(c1);
                    this.kb.addClass(c2);
                    this.kb.addSubClass(c1, c2);
                    continue;
                }
                if (tag.equals("disjoint")) {
                    int j;
                    ElementList children = DIGTellHandler.getElements(tell);
                    int n = children.getLength();
                    if (n <= 1) continue;
                    int clsCount = 0;
                    int indCount = 0;
                    ATermAppl[] classes = new ATermAppl[n];
                    ATermAppl[] inds = new ATermAppl[n];
                    for (j = 0; j < n; ++j) {
                        ATermAppl term = this.concept(children.item(j));
                        if (ATermUtils.isNominal(term)) {
                            inds[indCount++] = (ATermAppl)term.getArgument(0);
                            continue;
                        }
                        classes[clsCount++] = term;
                    }
                    for (j = 0; j < clsCount - 1; ++j) {
                        for (int k = j + 1; k < clsCount; ++k) {
                            this.kb.addDisjointClass(classes[j], classes[k]);
                        }
                    }
                    for (j = 0; j < indCount - 1; ++j) {
                        int k;
                        for (k = j + 1; k < indCount; ++k) {
                            this.kb.addDifferent(inds[j], inds[k]);
                        }
                        for (k = 0; k < clsCount; ++k) {
                            this.kb.addType(inds[j], ATermUtils.makeNot(classes[k]));
                        }
                    }
                    continue;
                }
                if (tag.equals("equalr")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl inv1 = this.getInverse(pair.item(0));
                    ATermAppl inv2 = this.getInverse(pair.item(1));
                    if (inv1 != null) {
                        if (inv2 != null) {
                            this.kb.addEquivalentProperty(inv1, inv2);
                            continue;
                        }
                        inv2 = this.property(pair.item(1));
                        this.kb.addObjectProperty(inv1);
                        this.kb.addObjectProperty(inv2);
                        this.kb.addInverseProperty(inv1, inv2);
                        continue;
                    }
                    if (inv2 != null) {
                        inv1 = this.property(pair.item(0));
                        this.kb.addObjectProperty(inv1);
                        this.kb.addObjectProperty(inv2);
                        this.kb.addInverseProperty(inv1, inv2);
                        continue;
                    }
                    this.kb.addEquivalentProperty(this.property(pair.item(0)), this.property(pair.item(1)));
                    continue;
                }
                if (tag.equals("impliesr")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl p1 = this.property(pair.item(0));
                    ATermAppl p2 = this.property(pair.item(1));
                    this.kb.addProperty(p1);
                    this.kb.addProperty(p2);
                    this.kb.addSubProperty(p1, p2);
                    continue;
                }
                if (tag.equals("functional")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    ATermAppl inv = this.getInverse(elem);
                    if (inv == null) {
                        ATermAppl p = this.property(elem);
                        this.kb.addProperty(p);
                        this.kb.addFunctionalProperty(p);
                        continue;
                    }
                    this.kb.addProperty(inv);
                    this.kb.addInverseFunctionalProperty(inv);
                    continue;
                }
                if (tag.equals("transitive")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    ATermAppl p = this.getInverse(elem);
                    if (p == null) {
                        p = this.property(elem);
                    }
                    this.kb.addObjectProperty(p);
                    this.kb.addTransitiveProperty(p);
                    continue;
                }
                if (tag.equals("domain")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl p = this.property(pair.item(0));
                    ATermAppl c = this.concept(pair.item(1));
                    this.kb.addObjectProperty(p);
                    this.kb.addClass(c);
                    this.kb.addDomain(p, c);
                    continue;
                }
                if (tag.equals("range")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl p = this.property(pair.item(0));
                    ATermAppl c = this.concept(pair.item(1));
                    this.kb.addObjectProperty(p);
                    this.kb.addClass(c);
                    this.kb.addRange(p, c);
                    continue;
                }
                if (tag.equals("rangeint")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    ATermAppl p = this.property(elem);
                    this.kb.addDatatypeProperty(p);
                    this.kb.addRange(p, ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#int"));
                    continue;
                }
                if (tag.equals("rangestring")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    ATermAppl p = this.property(elem);
                    this.kb.addDatatypeProperty(p);
                    this.kb.addRange(p, XSDString.getInstance().getName());
                    continue;
                }
                if (tag.equals("instanceof")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl ind = DIGTellHandler.individual(pair.item(0));
                    ATermAppl c = this.concept(pair.item(1));
                    this.kb.addIndividual(ind);
                    this.kb.addClass(c);
                    this.kb.addType(ind, c);
                    continue;
                }
                if (tag.equals("related")) {
                    list = DIGTellHandler.getElements(tell);
                    if (list.getLength() != 3) continue;
                    ATermAppl subj = DIGTellHandler.individual(list.item(0));
                    ATermAppl pred = this.property(list.item(1));
                    ATermAppl obj = DIGTellHandler.individual(list.item(2));
                    this.kb.addIndividual(subj);
                    this.kb.addObjectProperty(pred);
                    this.kb.addIndividual(obj);
                    this.kb.addPropertyValue(pred, subj, obj);
                    continue;
                }
                if (tag.equals("value")) {
                    list = DIGTellHandler.getElements(tell);
                    if (list.getLength() != 3) continue;
                    ATermAppl subj = DIGTellHandler.individual(list.item(0));
                    ATermAppl pred = this.property(list.item(1));
                    ATermAppl obj = this.literal(list.item(2));
                    this.kb.addIndividual(subj);
                    this.kb.addDatatypeProperty(pred);
                    this.kb.addPropertyValue(pred, subj, obj);
                    continue;
                }
                log.severe("ERROR (11) : " + tag + " is not a known tell operation");
                continue;
            }
            catch (RuntimeException e2) {
                log.severe("Ignoring tell command:\n" + DIGTellHandler.serialize(tell));
                StringWriter sw = new StringWriter();
                e2.printStackTrace(new PrintWriter(sw));
                log.severe("Exception: " + sw);
            }
        }
        return DIGResponse.createOkResponse();
    }
}

