/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import java.net.URI;
import java.util.Set;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.LimitedMapURIMapper;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.OWLOntologyCreationIOException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.util.NonMappingOntologyURIMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAPILoader
extends KBLoader {
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private Reasoner pellet = new Reasoner(this.manager);
    private LimitedMapURIMapper uriMapper = new LimitedMapURIMapper();

    @Override
    public KnowledgeBase getKB() {
        return this.pellet.getKB();
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public Set<OWLOntology> getOntologies() {
        return this.manager.getOntologies();
    }

    public Reasoner getReasoner() {
        return this.pellet;
    }

    @Override
    public void load() {
        this.pellet.loadOntologies(this.manager.getOntologies());
    }

    @Override
    protected void parseFile(String file) {
        try {
            URI fileURI = URI.create(file);
            this.uriMapper.addAllowedURI(fileURI);
            this.manager.loadOntology(URI.create(file));
        }
        catch (IllegalArgumentException e2) {
            throw new RuntimeException("Cannot parse file: " + file);
        }
        catch (OWLOntologyCreationIOException e3) {
            throw new RuntimeException(e3.getCause());
        }
        catch (OWLOntologyCreationException e4) {
            throw new RuntimeException(e4);
        }
    }

    @Override
    public void setIgnoreImports(boolean ignoreImports) {
        if (ignoreImports) {
            this.manager.clearURIMappers();
            this.manager.addURIMapper((OWLOntologyURIMapper)this.uriMapper);
            this.manager.setSilentMissingImportsHandling(true);
        } else {
            this.manager.clearURIMappers();
            this.manager.addURIMapper((OWLOntologyURIMapper)new NonMappingOntologyURIMapper());
            this.manager.setSilentMissingImportsHandling(false);
        }
    }

    @Override
    public void clear() {
        this.uriMapper.clear();
        this.pellet.clearOntologies();
        for (OWLOntology ont : this.manager.getOntologies()) {
            this.manager.removeOntology(ont.getURI());
        }
    }
}

