/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class ArrayIntSet
implements IntSet {
    private static int INIT_CAPACITY = 1;
    private int[] ints;
    private int size;

    public ArrayIntSet() {
        this.size = 0;
        this.ints = new int[INIT_CAPACITY];
    }

    public ArrayIntSet(ArrayIntSet other) {
        this.size = other.size;
        this.ints = new int[this.size];
        System.arraycopy(other.ints, 0, this.ints, 0, this.size);
    }

    private ArrayIntSet(ArrayIntSet set1, ArrayIntSet set2) {
        this.setToUnionOf(set1, set2);
    }

    public void add(int value) {
        this.ensureCapacity(this.size + 1);
        int index = this.binarySearch(this.ints, value);
        if (index < 0) {
            if ((index = -index - 1) < this.size) {
                System.arraycopy(this.ints, index, this.ints, index + 1, this.size - index);
            }
            this.ints[index] = value;
            ++this.size;
        }
    }

    public void addAll(IntSet values) {
        if (values instanceof ArrayIntSet) {
            this.setToUnionOf(this, (ArrayIntSet)values);
        } else {
            this.ensureCapacity(this.size + values.size());
            IntIterator i = values.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
    }

    private int binarySearch(int[] a, int key) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean contains(int value) {
        return this.binarySearch(this.ints, value) >= 0;
    }

    public IntSet copy() {
        return new ArrayIntSet(this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ints);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntSet)) {
            return false;
        }
        IntSet that = (IntSet)o;
        if (this.size() != that.size()) {
            return false;
        }
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            if (that.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.ints.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.ints;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.ints = new int[newCapacity];
            System.arraycopy(oldData, 0, this.ints, 0, this.size);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int next = 0;

            public boolean hasNext() {
                return this.next < ArrayIntSet.this.size;
            }

            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ArrayIntSet.this.ints[this.next++];
            }
        };
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints[this.size - 1];
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints[0];
    }

    public void remove(int value) {
        int index = this.binarySearch(this.ints, value);
        if (index >= 0) {
            if (index < this.size - 1) {
                System.arraycopy(this.ints, index + 1, this.ints, index, this.size - index - 1);
            }
            --this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.ints[0]);
        for (int i = 1; i < this.size; ++i) {
            buf.append(", ");
            buf.append(this.ints[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    private void setToUnionOf(ArrayIntSet set1, ArrayIntSet set2) {
        int[] ints1 = set1.ints;
        int[] ints2 = set2.ints;
        int size1 = set1.size;
        int size2 = set2.size;
        this.size = size1 + size2;
        this.ints = new int[this.size];
        int i1 = 0;
        int i2 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (i1 == size1) {
                System.arraycopy(ints2, i2, this.ints, i, size2 - i2);
                break;
            }
            if (i2 == size2) {
                System.arraycopy(ints1, i1, this.ints, i, size1 - i1);
                break;
            }
            if (ints1[i1] < ints2[i2]) {
                this.ints[i] = ints1[i1++];
                continue;
            }
            this.ints[i] = ints2[i2++];
            if (this.ints[i] != ints1[i1]) continue;
            ++i1;
            --this.size;
        }
    }

    public IntSet union(IntSet values) {
        return new ArrayIntSet(this, (ArrayIntSet)values);
    }
}

