/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import junit.framework.TestCase;
import org.eaglei.network.actions.EagleICentralQueryActionMap;
import org.eaglei.network.actions.NoopQueryAction;
import org.eaglei.network.actions.SystemPropertyTweaks;
import org.eaglei.network.driver.Query;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.actions.QueryAction;
import org.spin.tools.Util;

public class EagleICentralQueryActionMapTest
extends TestCase {
    protected void setUp() throws Exception {
        SystemPropertyTweaks.setSystemProperties();
    }

    public void testEagleICentralQueryActionMap() {
        EagleICentralQueryActionMap map = new EagleICentralQueryActionMap();
    }

    public void testContainsQueryType() {
        EagleICentralQueryActionMap map = new EagleICentralQueryActionMap();
        for (Query query : Query.values()) {
            EagleICentralQueryActionMapTest.assertTrue((boolean)map.containsQueryType(query.queryType));
        }
        EagleICentralQueryActionMapTest.assertFalse((boolean)map.containsQueryType("sdjhaskdkasjd"));
    }

    public void testGetQueryAction() throws Exception {
        EagleICentralQueryActionMap map = new EagleICentralQueryActionMap();
        try {
            map.getQueryAction("sdkhazkfhjkasdfh");
            EagleICentralQueryActionMapTest.fail((String)"Should have thrown");
        }
        catch (UnknownQueryTypeException expected) {
            // empty catch block
        }
        QueryAction rdfQueryAction = map.getQueryAction(Query.RDF.queryType);
        EagleICentralQueryActionMapTest.assertNotNull((Object)rdfQueryAction);
        EagleICentralQueryActionMapTest.assertEquals(NoopQueryAction.class, rdfQueryAction.getClass());
        QueryAction countQueryAction = map.getQueryAction(Query.Count.queryType);
        EagleICentralQueryActionMapTest.assertNotNull((Object)countQueryAction);
        EagleICentralQueryActionMapTest.assertEquals(NoopQueryAction.class, countQueryAction.getClass());
    }

    public void testGetQueryTypes() {
        EagleICentralQueryActionMap map = new EagleICentralQueryActionMap();
        EagleICentralQueryActionMapTest.assertEquals((Object)Util.asSet((Object[])new String[]{Query.RDF.queryType, Query.Count.queryType}), (Object)map.getQueryTypes());
    }

    public void testDestroy() throws Exception {
        EagleICentralQueryActionMap map = new EagleICentralQueryActionMap();
        EagleICentralQueryActionMapTest.assertFalse((boolean)map.isDestroyed());
        map.destroy();
        EagleICentralQueryActionMapTest.assertTrue((boolean)map.isDestroyed());
    }
}

