/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.QueryTestUtils;
import org.eaglei.network.actions.ResultCheckingStrategy;
import org.eaglei.network.actions.Shared;
import org.eaglei.network.actions.SystemPropertyTweaks;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.spin.tools.SPINUnitTest;

public final class CountQueryActionTest
extends SPINUnitTest {
    private static final Logger log = Logger.getLogger(CountQueryActionTest.class);
    private static final boolean INFO = log.isInfoEnabled();
    private EIOntModel eagleiOntModel;

    public void testPerform() throws Exception {
        Shared.setSearchProvider(null);
        Shared.setIsProviderInitialized((boolean)false);
        CountQueryAction action = new CountQueryAction();
        SearchCountRequest countRequest = this.makeCountRequest();
        QueryTestUtils.doPerformTest(action, countRequest, Serializer.SearchCountsSerializer, new ResultCheckingStrategy<SearchCounts>(){

            @Override
            public void checkResults(SearchCounts counts) {
                Assert.assertNotNull((Object)counts);
                for (EIClass eiClass : CountQueryActionTest.this.eagleiOntModel.getTopLevelClasses()) {
                    Assert.assertTrue((String)(counts.getClassesForCounts() + " does not contain " + eiClass.getEntity().getURI()), (boolean)counts.getClassesForCounts().contains(eiClass.getEntity().getURI()));
                }
                if (INFO) {
                    log.info((Object)("Count results: " + counts));
                }
            }
        });
    }

    private SearchCountRequest makeCountRequest() {
        SearchCountRequest countRequest = new SearchCountRequest(new SearchRequest());
        for (EIClass eiClass : this.eagleiOntModel.getTopLevelClasses()) {
            countRequest.addCountType(eiClass.getEntity().getURI());
        }
        return countRequest;
    }

    protected void setUp() throws Exception {
        super.setUp();
        SystemPropertyTweaks.setSystemProperties();
        this.eagleiOntModel = Shared.getOntModel();
        CountQueryActionTest.assertNotNull((Object)this.eagleiOntModel);
    }
}

