/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import junit.framework.TestCase;
import org.eaglei.network.actions.SearchProviderOp;
import org.eaglei.network.actions.SearchProviderOperations;
import org.eaglei.network.actions.SearchProviderQueryAction;
import org.eaglei.network.actions.Shared;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.node.actions.QueryException;

public class SearchProviderQueryActionTest
extends TestCase {
    public void testInitIsCalledLazily() throws Exception {
        MockSearchProvider mockProvider = new MockSearchProvider();
        Shared.setSearchProvider((SearchProvider)mockProvider);
        Shared.setIsProviderInitialized((boolean)false);
        SearchProviderQueryAction<SearchRequest, SearchResultSet> queryAction = new SearchProviderQueryAction<SearchRequest, SearchResultSet>(Serializer.SearchRequestSerializer, Serializer.SearchResultSetSerializer, SearchProviderOperations.invokesQuery((SearchProvider)mockProvider)){};
        SearchProviderQueryActionTest.assertFalse((boolean)mockProvider.isInitialized);
        queryAction.perform(null, (Object)new SearchRequest());
        SearchProviderQueryActionTest.assertTrue((boolean)mockProvider.isInitialized);
    }

    public void testHandleOpPerformFailure() throws Exception {
        SearchProviderQueryAction<SearchRequest, SearchResultSet> queryAction = new SearchProviderQueryAction<SearchRequest, SearchResultSet>(Serializer.SearchRequestSerializer, Serializer.SearchResultSetSerializer, (SearchProviderOp)new CantPerformSearchProviderOp()){};
        try {
            queryAction.perform(null, (Object)new SearchRequest());
            SearchProviderQueryActionTest.fail((String)"Should have thrown");
        }
        catch (QueryException queryException) {
            // empty catch block
        }
    }

    public void testHandleOutputSerializationFailure() throws Exception {
        MockSearchProvider mockProvider = new MockSearchProvider();
        SearchProviderQueryAction<SearchRequest, SearchResultSet> queryAction = new SearchProviderQueryAction<SearchRequest, SearchResultSet>(Serializer.SearchRequestSerializer, (Serializer)new AlwaysFailsSerializer(), SearchProviderOperations.invokesQuery((SearchProvider)mockProvider)){};
        try {
            queryAction.perform(null, (Object)new SearchRequest());
            SearchProviderQueryActionTest.fail((String)"Should have thrown");
        }
        catch (QueryException queryException) {
            // empty catch block
        }
    }

    static final class MockSearchProvider
    implements SearchProvider {
        volatile boolean isInitialized = false;

        MockSearchProvider() {
        }

        public SearchResultSet query(SearchRequest request) throws IOException {
            return new SearchResultSet(request);
        }

        public SearchCounts count(SearchCountRequest request) throws IOException {
            return new SearchCounts(request.getRequest());
        }

        public void init() throws IOException {
            this.isInitialized = true;
        }
    }

    private static final class AlwaysFailsSerializer
    implements Serializer<SearchResultSet> {
        AlwaysFailsSerializer() {
        }

        public String serialize(SearchResultSet object) throws SerializationException {
            throw new SerializationException();
        }

        public SearchResultSet deserialize(String serialized) throws SerializationException {
            throw new SerializationException();
        }
    }

    private static final class CantPerformSearchProviderOp
    implements SearchProviderOp<SearchRequest, SearchResultSet> {
        CantPerformSearchProviderOp() {
        }

        public SearchProvider getSearchProvider() {
            return null;
        }

        public SearchResultSet perform(SearchRequest param) throws IOException {
            throw new IOException();
        }
    }
}

