package org.eaglei.network.actions;

import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.search.provider.lucene.RepositoryHarvester;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NetworkSearchConfig
{
    @Autowired
    private RepositoryHarvester harvester;

    @Autowired
    private EIOntModel eagleiOntModel;

    @Autowired
    private LuceneSearchProviderIndexer indexer;

    @Bean
    public NetworkSearchProvider networkSearchProvider()
    {
        return new NetworkSearchProvider(eagleiOntModel, harvester, indexer);
    }

    // TODO: is it right to call the NetworkSearchProvider factory method like
    // this?
    @Bean
    public RDFQueryAction rdfQueryAction()
    {
        return new RDFQueryAction(networkSearchProvider());
    }

    // TODO: is it right to call the NetworkSearchProvider factory method like
    // this?
    @Bean
    public CountQueryAction countQueryAction()
    {
        return new CountQueryAction(networkSearchProvider());
    }
}
