/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLRational
extends AbstractBaseDatatype<Number> {
    private static final OWLRational instance = new OWLRational();
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLRational getInstance() {
        return instance;
    }

    private OWLRational() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#rational"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        Number n = this.getValue(input);
        if (n instanceof Rational) {
            String canonicalForm = Rational.simplify((Rational)n).toString();
            if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
        }
        return OWLReal.getInstance().getLiteral(OWLRealUtils.getCanonicalObject(n));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Rational) {
            Rational r = (Rational)value;
            String lexicalForm = r.toString();
            return ATermUtils.makeTypedLiteral(lexicalForm, this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return OWLReal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        try {
            return OWLRealUtils.getCanonicalObject(Rational.valueOf(lexicalForm));
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

