/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;

public class NIOFSDirectory
extends FSDirectory {
    public NIOFSDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public NIOFSDirectory(File path) throws IOException {
        super(path, null);
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        this.ensureOpen();
        return new NIOFSIndexInput(new File(this.getFile(), name), bufferSize, this.getReadChunkSize());
    }

    public IndexOutput createOutput(String name) throws IOException {
        this.initOutput(name);
        return new SimpleFSDirectory.SimpleFSIndexOutput(new File(this.directory, name));
    }

    protected static class NIOFSIndexInput
    extends SimpleFSDirectory.SimpleFSIndexInput {
        private ByteBuffer byteBuf;
        private byte[] otherBuffer;
        private ByteBuffer otherByteBuf;
        final FileChannel channel;

        public NIOFSIndexInput(File path, int bufferSize, int chunkSize) throws IOException {
            super(path, bufferSize, chunkSize);
            this.channel = this.file.getChannel();
        }

        protected void newBuffer(byte[] newBuffer) {
            super.newBuffer(newBuffer);
            this.byteBuf = ByteBuffer.wrap(newBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.isClone && this.file.isOpen) {
                try {
                    this.channel.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.file.close();
                    throw throwable;
                }
                this.file.close();
                {
                }
            }
        }

        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            int readLength;
            ByteBuffer bb;
            if (b == this.buffer && 0 == offset) {
                assert (this.byteBuf != null);
                this.byteBuf.clear();
                this.byteBuf.limit(len);
                bb = this.byteBuf;
            } else if (offset == 0) {
                if (this.otherBuffer != b) {
                    this.otherBuffer = b;
                    this.otherByteBuf = ByteBuffer.wrap(b);
                } else {
                    this.otherByteBuf.clear();
                }
                this.otherByteBuf.limit(len);
                bb = this.otherByteBuf;
            } else {
                bb = ByteBuffer.wrap(b, offset, len);
            }
            int readOffset = bb.position();
            assert (readLength == len);
            long pos = this.getFilePointer();
            try {
                int i;
                for (readLength = bb.limit() - readOffset; readLength > 0; readLength -= i) {
                    int limit = readLength > this.chunkSize ? readOffset + this.chunkSize : readOffset + readLength;
                    bb.limit(limit);
                    i = this.channel.read(bb, pos);
                    if (i == -1) {
                        throw new IOException("read past EOF");
                    }
                    pos += (long)i;
                    readOffset += i;
                }
            }
            catch (OutOfMemoryError e2) {
                OutOfMemoryError outOfMemoryError = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a a value smaller than the current chunk size (" + this.chunkSize + ")");
                outOfMemoryError.initCause(e2);
                throw outOfMemoryError;
            }
        }
    }
}

