/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class NonOntologyProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final EIEntity WFStateEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowState"), "Workflow state");
    private static final EIEntity WFOwnerEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner"), "Workflow owner");
    private static final EIEntity CreatedEntity = EIEntity.create(EIURI.create("http://purl.org/dc/terms/created"), "Creation date");
    private static final EIEntity ModifiedEntity = EIEntity.create(EIURI.create("http://purl.org/dc/terms/modified"), "Last modification date");
    private static final EIEntity stubEntity = EIEntity.create("http://eagle-i.org/ont/datatools/1.0/is_stub", "");
    private Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIEntity>>();
    private Map<EIEntity, Set<String>> nonOntologyLiteralProperties = new HashMap<EIEntity, Set<String>>();
    private Map<EIEntity, EIEntity> readOnlyResourceProperties;
    private Map<EIEntity, String> readOnlyLiteralProperties;

    NonOntologyProperties() {
    }

    public String getStubPropertyValue() {
        Set<String> values = this.nonOntologyLiteralProperties.get(stubEntity);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public EIEntity getWFState() {
        if (this.readOnlyResourceProperties == null) {
            return null;
        }
        if (this.readOnlyResourceProperties.containsKey(WFStateEntity)) {
            return this.readOnlyResourceProperties.get(WFStateEntity);
        }
        return null;
    }

    public void setWFState(EIEntity state) {
        this.setReadOnlyResourceProperty(WFStateEntity, state);
    }

    public EIEntity getWFOwner() {
        if (this.readOnlyResourceProperties == null) {
            return null;
        }
        if (this.readOnlyResourceProperties.containsKey(WFOwnerEntity)) {
            return this.readOnlyResourceProperties.get(WFOwnerEntity);
        }
        return null;
    }

    public void setWFOwner(EIEntity ownerUri) {
        this.setReadOnlyResourceProperty(WFOwnerEntity, ownerUri);
    }

    public String getCreationDate() {
        if (this.readOnlyLiteralProperties == null) {
            return null;
        }
        if (this.readOnlyLiteralProperties.containsKey(CreatedEntity)) {
            return this.readOnlyLiteralProperties.get(CreatedEntity);
        }
        return null;
    }

    public void setCreationDate(String date2) {
        this.setReadOnlyLiteralProperty(CreatedEntity, date2);
    }

    public String getModificationDate() {
        if (this.readOnlyLiteralProperties == null) {
            return null;
        }
        if (this.readOnlyLiteralProperties.containsKey(ModifiedEntity)) {
            return this.readOnlyLiteralProperties.get(ModifiedEntity);
        }
        return null;
    }

    public void setModificationDate(String date2) {
        this.setReadOnlyLiteralProperty(ModifiedEntity, date2);
    }

    public Map<EIEntity, Set<EIEntity>> getNonOntologyResourceProperties() {
        return this.nonOntologyResourceProperties;
    }

    public void addNonOntologyResourceProperty(EIEntity property, EIEntity resource) {
        Set<EIEntity> pValues = this.nonOntologyResourceProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIEntity>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public Set<EIEntity> getNonOntologyResourceProperty(EIEntity property) {
        return this.nonOntologyResourceProperties.get(property);
    }

    public void replaceNonOntologyResourcePropertyValue(EIEntity property, EIURI oldValue, EIEntity newValue) {
        Set<EIEntity> pValues = this.nonOntologyResourceProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIEntity>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.remove(EIEntity.create(oldValue, ""));
        if (newValue != null && newValue != EIEntity.NULL_ENTITY) {
            pValues.add(newValue);
        }
    }

    public void replaceNonOntologyResourcePropertyAllValues(EIEntity property, Set<EIEntity> values) {
        this.nonOntologyResourceProperties.put(property, values);
    }

    public Map<EIEntity, Set<String>> getNonOntologyLiteralProperties() {
        return this.nonOntologyLiteralProperties;
    }

    public void addNonOntologyLiteralProperty(EIEntity property, String literal) {
        Set<String> pValues = this.nonOntologyLiteralProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.nonOntologyLiteralProperties.put(property, pValues);
        }
        pValues.add(literal);
    }

    public Set<String> getNonOntologyLiteralProperty(EIEntity property) {
        return this.nonOntologyLiteralProperties.get(property);
    }

    public void replaceNonOntologyLiteralProperty(EIEntity property, String oldValue, String newValue) {
        Set<String> pValues = this.nonOntologyLiteralProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.nonOntologyLiteralProperties.put(property, pValues);
        }
        pValues.remove(oldValue);
        if (newValue != null && !newValue.equals("")) {
            pValues.add(newValue);
        }
    }

    public void replaceNonOntologyLiteralPropertyAllValues(EIEntity property, Set<String> values) {
        this.nonOntologyLiteralProperties.put(property, values);
    }

    public Map<EIEntity, EIEntity> getReadOnlyResourceProperties() {
        if (this.readOnlyResourceProperties == null) {
            return Collections.emptyMap();
        }
        return this.readOnlyResourceProperties;
    }

    public void setReadOnlyResourceProperty(EIEntity property, EIEntity value) {
        if (this.readOnlyResourceProperties == null) {
            this.readOnlyResourceProperties = new HashMap<EIEntity, EIEntity>();
        }
        this.readOnlyResourceProperties.put(property, value);
    }

    public Map<EIEntity, String> getReadOnlyLiteralProperties() {
        if (this.readOnlyLiteralProperties == null) {
            return Collections.emptyMap();
        }
        return this.readOnlyLiteralProperties;
    }

    public void setReadOnlyLiteralProperties(Map<EIEntity, String> readOnlyLiteralProperties) {
        this.readOnlyLiteralProperties = readOnlyLiteralProperties;
    }

    public void setReadOnlyLiteralProperty(EIEntity property, String value) {
        if (this.readOnlyLiteralProperties == null) {
            this.readOnlyLiteralProperties = new HashMap<EIEntity, String>();
        }
        this.readOnlyLiteralProperties.put(property, value);
    }
}

