/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.tools;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eaglei.network.actions.EagleIQueryActions;
import org.eaglei.network.actions.NoopQueryAction;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.QueryTypeConfig;
import org.spin.tools.config.RoutingTableConfig;

public final class ConfigGenerator {
    private ConfigGenerator() {
    }

    public static void main(String[] args) throws Exception {
        NodeType nodeType;
        if (!ConfigGenerator.checkUsage(args)) {
            System.err.println("Usage: ");
            System.err.println("\tConfigGenerator Institutional <parent_url>");
            System.err.println("or");
            System.err.println("\tConfigGenerator Central <child_url1> <child_url2> ... <child_urlN>");
            return;
        }
        try {
            nodeType = NodeType.valueOf(args[0]);
        }
        catch (Exception e2) {
            System.err.println("Unknown node type: allowed values are " + NodeType.values());
            return;
        }
        NodeConfig eagleIConfig = ConfigGenerator.makeEagleINodeConfig(nodeType);
        File nodeXMLFile = new File(Module.node.name() + ".xml");
        JAXBUtils.marshalToFile((Object)eagleIConfig, (File)nodeXMLFile);
        System.out.println("Node config written to " + nodeXMLFile.getCanonicalPath());
        List<String> urls = Arrays.asList(Arrays.copyOfRange(args, 1, args.length));
        PeerGroupConfig peerGroup = ConfigGenerator.makePeerGroup(urls, nodeType);
        File routingTableXMLFile = new File(Module.routingtable.name() + ".xml");
        JAXBUtils.marshalToFile((Object)new RoutingTableConfig().withPeerGroup(peerGroup), (File)routingTableXMLFile);
        System.out.println("Routing table config written to " + routingTableXMLFile.getCanonicalPath());
    }

    static PeerGroupConfig makePeerGroup(List<String> urls, NodeType nodeType) {
        PeerGroupConfig peerGroup = new PeerGroupConfig("EAGLE-I-TEST");
        if (nodeType.isCentral()) {
            peerGroup = peerGroup.withParent(null);
            for (String childURL : urls) {
                peerGroup = peerGroup.withChild(ConfigGenerator.soap(childURL));
            }
        } else if (nodeType.isInstitutional()) {
            peerGroup = peerGroup.withParent(ConfigGenerator.soap(urls.get(0)));
        }
        return peerGroup;
    }

    static boolean checkUsage(String[] args) {
        return args.length >= 2;
    }

    static EndpointConfig soap(String url) {
        return new EndpointConfig(EndpointType.SOAP, url);
    }

    static NodeConfig makeEagleINodeConfig(NodeType nodeType) {
        return nodeType.mungeNodeConfig(NodeConfig.Default).withCacheTTL(Long.valueOf(1800000L)).withIsAuthenticator(Boolean.valueOf(false));
    }

    static enum NodeType {
        Institutional{

            @Override
            public NodeConfig mungeNodeConfig(NodeConfig original) {
                NodeConfig munged = original.withIsAggregator(Boolean.valueOf(false)).withIsBroadcaster(Boolean.valueOf(false)).withIsQueryable(Boolean.valueOf(true));
                for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
                    munged = munged.withQuery(queryActionDef.toQueryTypeConfig());
                }
                return munged;
            }
        }
        ,
        Central{

            @Override
            public NodeConfig mungeNodeConfig(NodeConfig original) {
                NodeConfig munged = original.withIsAggregator(Boolean.valueOf(true)).withIsBroadcaster(Boolean.valueOf(true)).withIsQueryable(Boolean.valueOf(true));
                for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
                    munged = munged.withQuery(new QueryTypeConfig(queryActionDef.query().queryType, NoopQueryAction.class.getName()));
                }
                return munged;
            }
        };


        public abstract NodeConfig mungeNodeConfig(NodeConfig var1);

        public final boolean isCentral() {
            return this == Central;
        }

        public final boolean isInstitutional() {
            return this == Institutional;
        }
    }
}

