/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.search.provider.lucene.LuceneIndexSchema;

public abstract class AbstractLuceneIndexer
implements ResourceChangeListener,
LuceneIndexSchema {
    private static final Log logger = LogFactory.getLog(AbstractLuceneIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private int count;
    protected EIOntModel eiOntModel;
    protected Analyzer analyzer;
    protected Directory directory;
    private boolean indexEmpty;
    private IndexWriter iwriter;
    private HashMap<EIURI, List<Document>> mapURIToDocuments;
    private Set<EIEntity> resourceRoots = new HashSet<EIEntity>();
    private static final EIURI RESOURCE_PROVIDER_PROPERTY = EIURI.create("http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider");

    public AbstractLuceneIndexer(EIOntModel eiOntModel, Analyzer analyzer, Directory directory) {
        this.eiOntModel = eiOntModel;
        this.analyzer = analyzer;
        this.directory = directory;
        for (EIClass c : eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            this.resourceRoots.add(c.getEntity());
        }
        this.indexEmpty = true;
    }

    @Override
    public void onChangeStreamStart(EIEntity institution) {
        logger.debug("onChangeStreamStart: " + institution.getLabel());
        this.count = 0;
        try {
            this.iwriter = new IndexWriter(this.directory, this.analyzer, IndexWriter.MaxFieldLength.LIMITED);
            this.mapURIToDocuments = new HashMap();
        }
        catch (IOException e2) {
            logger.error("Error creating lucene IndexWriter" + e2);
        }
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        assert (event != null) : "Null change event notification";
        ++this.count;
        if (this.count % 400 == 0) {
            logger.debug("Received " + this.count + " change events...");
        }
    }

    @Override
    public void onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        logger.debug("onChangeStreamEnd: " + institution.getLabel() + "   num change events " + this.count + " last modifed: " + dateFormat.format(lastModifiedDate));
        this.commitDocumentCache();
    }

    protected void commitDocumentCache() {
        try {
            for (EIURI uri : this.mapURIToDocuments.keySet()) {
                List<Document> docs = this.mapURIToDocuments.get(uri);
                if (!this.indexEmpty) {
                    this.deleteDocumentsFromIndex(uri);
                }
                for (Document doc : docs) {
                    this.iwriter.addDocument(doc);
                }
            }
            if (this.indexEmpty && this.mapURIToDocuments.size() > 0) {
                this.indexEmpty = false;
            }
            this.iwriter.optimize();
            this.iwriter.close();
            logger.debug("wrote " + this.mapURIToDocuments.size() + " Documents to index.");
        }
        catch (CorruptIndexException e2) {
            logger.error("Error writing change event Documents" + e2);
        }
        catch (IOException e3) {
            logger.error("Error writing change event Documents" + e3);
        }
        this.iwriter = null;
        this.mapURIToDocuments = null;
    }

    protected List<Document> getDocuments(EIURI uri) {
        List<Document> docs = this.mapURIToDocuments.get(uri);
        if (docs != null) {
            return docs;
        }
        if (!this.indexEmpty && (docs = this.getDocumentsFromIndex(uri)) != null) {
            this.setDocuments(uri, docs);
            return docs;
        }
        return docs;
    }

    protected void setDocuments(EIURI uri, List<Document> docs) {
        this.mapURIToDocuments.put(uri, docs);
    }

    protected List<Document> getDocumentsFromIndex(EIURI uri) {
        try {
            TermQuery uriQuery = new TermQuery(new Term("uri", uri.toString()));
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            searcher.setDefaultFieldSortScoring(true, true);
            TopDocs docs = searcher.search((Query)uriQuery, 1);
            if (docs.totalHits == 0) {
                return null;
            }
            ArrayList<Document> result = new ArrayList<Document>(docs.scoreDocs.length);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                result.add(searcher.doc(scoreDoc.doc));
            }
            return result;
        }
        catch (IOException e2) {
            logger.error(e2);
            return null;
        }
    }

    protected List<Document> deleteDocuments(EIURI uri) {
        List<Document> docs = this.getDocuments(uri);
        this.mapURIToDocuments.remove(uri);
        if (!this.indexEmpty) {
            this.deleteDocumentsFromIndex(uri);
        }
        return docs;
    }

    protected void deleteDocumentsFromIndex(EIURI uri) {
        try {
            assert (this.iwriter != null);
            TermQuery uriQuery = new TermQuery(new Term("uri", uri.toString()));
            this.iwriter.deleteDocuments((Query)uriQuery);
            logger.debug("deleted " + uri.toString() + " from index.");
        }
        catch (IOException e2) {
            logger.error(e2);
        }
    }
}

