/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.suggest;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.lucene.AutoSuggestIndexAnalyzer;
import org.eaglei.lexical.lucene.AutoSuggestQueryAnalyzer;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.provider.lucene.harvest.DataHarvesterConfig;
import org.eaglei.search.provider.lucene.suggest.LuceneAutoSuggestIndexer;
import org.eaglei.search.provider.lucene.suggest.LuceneAutoSuggestProvider;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DataHarvesterConfig.class})
public class LuceneAutoSuggestConfig {
    private static final Log logger = LogFactory.getLog(LuceneAutoSuggestConfig.class);
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private InstitutionRegistry institutionRegistry;
    @Autowired
    private PollingDataHarvester dataHarvester;

    @Bean
    public Directory autoSuggestDirectory() {
        try {
            String indexDir = System.getProperty("org.eaglei.lucene.dir");
            if (indexDir != null) {
                indexDir = indexDir + "/suggest";
                indexDir = indexDir + "/" + this.institutionRegistry.getLocalNodeId();
                File dir = new File(indexDir);
                logger.debug("Using Lucene index directory: " + dir.getAbsolutePath());
                if (dir.exists()) {
                    File[] contents = dir.listFiles();
                    if (contents != null) {
                        for (File f : contents) {
                            if (f.delete()) continue;
                            throw new RuntimeException("Error deleting lucene directory: " + f.getAbsolutePath());
                        }
                    }
                    if (!dir.delete()) {
                        throw new RuntimeException("Error deleting lucene directory: " + dir.getAbsolutePath());
                    }
                    logger.debug("Deleted Lucene index directory: " + dir.getAbsolutePath());
                }
                if (!dir.mkdirs()) {
                    throw new RuntimeException("Error creating lucene directory: " + dir.getAbsolutePath());
                }
                return FSDirectory.open(dir);
            }
            RAMDirectory ram = new RAMDirectory();
            logger.debug("Using Lucene RAMDirectory " + ram.toString());
            return ram;
        }
        catch (IOException e2) {
            logger.error("Exception getting Lucene directory, using RAMDirectory. ", e2);
            return new RAMDirectory();
        }
    }

    @Bean
    public Analyzer autoSuggestIndexAnalyzer() {
        return new AutoSuggestIndexAnalyzer();
    }

    @Bean
    public Analyzer autoSuggestQueryAnalyzer() {
        return new AutoSuggestQueryAnalyzer();
    }

    @Bean
    public LuceneAutoSuggestIndexer autoSuggestIndexer() {
        LuceneAutoSuggestIndexer indexer = new LuceneAutoSuggestIndexer(this.eagleiOntModel, this.autoSuggestIndexAnalyzer(), this.autoSuggestDirectory());
        this.dataHarvester.addChangeListener(indexer);
        return indexer;
    }

    @Bean
    public LuceneAutoSuggestProvider autoSuggestProvider() throws IOException {
        return new LuceneAutoSuggestProvider(this.autoSuggestQueryAnalyzer(), this.autoSuggestIndexAnalyzer(), this.autoSuggestDirectory());
    }
}

