/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralIterator
implements Iterator<Literal> {
    protected ABox abox;
    protected List<ATermAppl> nodeList;
    protected int index;
    protected int start;
    protected int stop;

    public LiteralIterator(ABox abox) {
        this(abox, true);
    }

    protected LiteralIterator(ABox abox, boolean findNext) {
        this.abox = abox;
        this.nodeList = abox.getNodeNames();
        this.start = 0;
        this.stop = this.nodeList.size();
        this.index = this.start;
        if (findNext) {
            this.findNext();
        }
    }

    public LiteralIterator(ABox abox, int start, int stop) {
        this.abox = abox;
        this.nodeList = abox.getNodeNames();
        this.start = start;
        this.stop = Math.max(stop, this.nodeList.size());
        this.index = start;
        this.findNext();
    }

    public int getIndex() {
        return this.index;
    }

    protected void findNext() {
        Node node;
        while (this.index < this.stop && ((node = this.abox.getNode(this.nodeList.get(this.index))).isPruned() || !node.isLiteral())) {
            ++this.index;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.index < this.stop;
    }

    public void reset() {
        this.index = this.start;
        this.findNext();
    }

    public void jump(int i) {
        this.index = i;
    }

    @Override
    public Literal next() {
        this.findNext();
        Literal lit = this.abox.getLiteral(this.nodeList.get(this.index++));
        return lit;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

