/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.blocking;

import aterm.ATermAppl;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.utils.SetUtils;

public abstract class Blocking {
    protected boolean subset(Individual x, Individual y) {
        Set<ATermAppl> xTypes = x.getTypes();
        Set<ATermAppl> yTypes = y.getTypes();
        return SetUtils.subset(xTypes, yTypes);
    }

    protected boolean equals(Individual x, Individual y) {
        Set<ATermAppl> xTypes = x.getTypes();
        Set<ATermAppl> yTypes = y.getTypes();
        return SetUtils.equals(xTypes, yTypes);
    }

    public boolean isBlocked(Individual x) {
        if (x.isRoot()) {
            return false;
        }
        boolean isBlocked = this.isIndirectlyBlocked(x) || this.isDirectlyBlocked(x);
        return isBlocked;
    }

    public boolean isIndirectlyBlocked(Individual x) {
        Individual parent = x.getParent();
        if (parent == null) {
            return false;
        }
        return this.isBlocked(parent);
    }

    public abstract boolean isDirectlyBlocked(Individual var1);
}

