/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.mail.MailException;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSendException
extends MailException {
    private final transient Map<Object, Exception> failedMessages;
    private Exception[] messageExceptions;

    public MailSendException(String msg) {
        this(msg, null);
    }

    public MailSendException(String msg, Throwable cause) {
        super(msg, cause);
        this.failedMessages = new LinkedHashMap<Object, Exception>();
    }

    public MailSendException(Map<Object, Exception> failedMessages) {
        super((String)null);
        this.failedMessages = new LinkedHashMap<Object, Exception>(failedMessages);
        this.messageExceptions = failedMessages.values().toArray(new Exception[failedMessages.size()]);
    }

    public final Map<Object, Exception> getFailedMessages() {
        return this.failedMessages;
    }

    public final Exception[] getMessageExceptions() {
        return this.messageExceptions != null ? this.messageExceptions : new Exception[]{};
    }

    @Override
    public String getMessage() {
        if (ObjectUtils.isEmpty(this.messageExceptions)) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder("Failed messages: ");
        int i = 0;
        while (i < this.messageExceptions.length) {
            Exception subEx = this.messageExceptions[i];
            sb.append(subEx.toString());
            if (i < this.messageExceptions.length - 1) {
                sb.append("; ");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        if (ObjectUtils.isEmpty(this.messageExceptions)) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("; nested exceptions (").append(this.messageExceptions.length).append(") are:");
        int i = 0;
        while (i < this.messageExceptions.length) {
            Exception subEx = this.messageExceptions[i];
            sb.append('\n').append("Failed message ").append(i + 1).append(": ");
            sb.append(subEx);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        if (ObjectUtils.isEmpty(this.messageExceptions)) {
            super.printStackTrace(ps);
        } else {
            ps.println(String.valueOf(this.getClass().getName()) + "; nested exception details (" + this.messageExceptions.length + ") are:");
            int i = 0;
            while (i < this.messageExceptions.length) {
                Exception subEx = this.messageExceptions[i];
                ps.println("Failed message " + (i + 1) + ":");
                subEx.printStackTrace(ps);
                ++i;
            }
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        if (ObjectUtils.isEmpty(this.messageExceptions)) {
            super.printStackTrace(pw);
        } else {
            pw.println(String.valueOf(this.getClass().getName()) + "; nested exception details (" + this.messageExceptions.length + ") are:");
            int i = 0;
            while (i < this.messageExceptions.length) {
                Exception subEx = this.messageExceptions[i];
                pw.println("Failed message " + (i + 1) + ":");
                subEx.printStackTrace(pw);
                ++i;
            }
        }
    }
}

