package org.eaglei.repository.vocabulary;

import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.URI;

/**
 * Constants related to the eagle-i Data Model Ontology
 * URIs of useful classes and properties.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class DATAMODEL
{
    /**
     * URI of Data Model Ontology, at least for naming Named Graph.
     * It includes too many Namespace Prefixes to isolate one.
     */
    public static final String NAMESPACE = "http://purl.obolibrary.org/obo/ero.owl";

    /** Constant <code>NAMESPACE_URI</code> */
    public static final URI NAMESPACE_URI =  new URIImpl(NAMESPACE);


    // XXX TODO: add other constants, eg. annotation props, as necessary.
}
