package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.sql.Connection;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.model.URI;
import org.eaglei.repository.status.ErrorSendingException;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.eaglei.repository.Access;
import org.eaglei.repository.User;
import org.eaglei.repository.admin.AuthUser;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.NotFoundException;

public final class editUserPortlet_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    private static boolean isDifferent(String a, String b)
    {
        return a == null && b != null ||
                a != null && b == null ||
                !((a == null && b == null) || a.equals(b));
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write('\n');

    Logger log = LogManager.getLogger("org.eaglei.repository.admin.editUserPortlet.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    boolean onlyPassword = request.getParameter("only_password") != null;
    String password = request.getParameter("password");
    String password_confirm = request.getParameter("password_confirm");
    String first = request.getParameter("first");
    String last = request.getParameter("last");
    String mailbox = request.getParameter("mailbox");
    String submit = request.getParameter("submit");
    String username = request.getParameter("username");
    final String empty = "";
    if (empty.equals(first))
        first = null;
    if (empty.equals(last))
        last = null;
    if (empty.equals(mailbox))
        mailbox = null;

    try {
        User uu = null;
        if (username == null) {
            uu = Access.getPrincipalUser(request);
            if (uu == null)
                throw new BadRequestException("There is no authenticated user.");
            else
                username = uu.getUsername();
        } else {
            uu = User.findUsername(request, username);
            if (uu == null)
                throw new NotFoundException("Cannot find a user named: "+username);
        }

        if (submit == null) {
            if (first == null)
                first = uu.getFirstName();
            if (last == null)
                last = uu.getLastName();
            if (mailbox == null)
                mailbox = uu.getMbox();
        } else {
            boolean passwordChanged = false;

            // NOTE: input of type password will be "", not null, even when nothing was entered.
            if (password != null && password.length() > 0) {
                if (password_confirm != null && password.equals(password_confirm)) {
                    // XXX log.debug("Got password = \""+password+"\", confirm = \""+password_confirm+"\"");
                    AuthUser au = AuthUser.find(username);
                    if (au == null) {
                        message = "User not found in authentication database: "+username;
                        messageSuccess = false;
                    } else {
                        au.setPassword(password);
                        Connection c = AuthUser.startTransaction();
                        try {
                            au.update(c);
                            AuthUser.commitTransaction(c);
                            c = null;
                            log.debug("Changed the password.");
                            passwordChanged = true;
                        } finally {
                            if (c != null)
                                AuthUser.abortTransaction(c);
                        }
                    }
                } else {
                    message = "Password was not confirmed or versions do not match.";
                    messageSuccess = false;
                }
            }

            boolean changed = false;
            if (messageSuccess && !onlyPassword) {
                if (isDifferent(first, uu.getFirstName())) {
                    uu.setFirstName(request, first);
                    log.debug("Changed first name = "+first);
                    changed = true;
                }
                if (isDifferent(last, uu.getLastName())) {
                    uu.setLastName(request, last);
                    log.debug("Changed last name = "+last);
                    changed = true;
                }
                if (isDifferent(mailbox, uu.getMbox())) {
                    uu.setMbox(request, mailbox);
                    log.debug("Changed mbox = "+mailbox);
                    changed = true;
                }
                if (changed)
                    uu.update(request);
            }
            if ((changed || passwordChanged) && messageSuccess)
                message = "User has been modified.";
        }
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n  <head>\n    <title>Eagle-I Data Repository - Edit User Metadata</title>\n  </head>\n  <body>\n");

    if (message != null) {

      out.write("\n      <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n     </h3>\n");

    }

      out.write("\n\n    <form action=\"\">\n      <input type=\"hidden\" name=\"username\" value=\"");
      out.print( username );
      out.write("\"/>\n");

    if (onlyPassword) {

      out.write("\n      <input type=\"hidden\" name=\"only_password\" value=\"true\"/>\n");

    } else {

      out.write("\n      <label for=\"id_first\"><b>First Name:</b> </label>\n      <input type=\"text\" name=\"first\" id=\"id_first\" size=\"30\" value=\"");
      out.print( first == null ?  "" :  first );
      out.write("\"/>\n      <br/>\n      <label for=\"id_last\"><b>Last Name:</b> </label>\n      <input type=\"text\" name=\"last\" id=\"id_last\" size=\"30\" value=\"");
      out.print( last == null ? "" : last );
      out.write("\"/>\n      <br/>\n      <label for=\"id_mailbox\"><b>Mailbox:</b> </label>\n      <input type=\"text\" name=\"mailbox\" id=\"id_mailbox\" size=\"40\" value=\"");
      out.print( mailbox == null ? "" : mailbox );
      out.write("\"/>\n");

    }

      out.write("\n      <br/>\n      <label for=\"id_password\"><b>Password:</b> </label>\n      <input type=\"password\" name=\"password\" id=\"id_password\" size=\"20\"/>\n      <br/>\n      <label for=\"id_password_confirm\"><b>Confirm Password:</b> </label>\n      <input type=\"password\" name=\"password_confirm\" id=\"id_password_confirm\" size=\"20\"/>\n      <br/>\n      &nbsp;&nbsp;&nbsp;&nbsp;\n      <button type=\"reset\">Reset Form</button>\n      &nbsp;&nbsp;&nbsp;&nbsp;\n      <button name=\"submit\" value=\"submit\" type=\"submit\">Submit</button>\n    </form>\n\n  </body>\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
