package org.eaglei.repository.status;

import org.eaglei.repository.status.ErrorSendingException;
import javax.servlet.http.HttpServletResponse;

/**
 * Signal a fatal runtime error that should result in a
 * 500 (ise) status returned to the HTTP client.
 *
 * @author lcs
 * @version $Id: $
 */
public class InternalServerErrorException extends ErrorSendingException
{

    private static final long serialVersionUID = 1L;
    
    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return HttpServletResponse.SC_INTERNAL_SERVER_ERROR;
    }
    /**
     * <p>Constructor for InternalServerErrorException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public InternalServerErrorException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for InternalServerErrorException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public InternalServerErrorException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for InternalServerErrorException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public InternalServerErrorException(Throwable cause)
    {
        super(cause);
    }
}
