package org.eaglei.repository.admin;

import java.sql.*;

import org.eaglei.repository.Access;
import org.eaglei.repository.User;
import org.eaglei.repository.Role;
import org.eaglei.repository.DataRepository;

import java.io.File;
import java.io.IOException;

import java.util.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Iterator;
import java.util.Comparator;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.ServletException;
import javax.naming.*;
import javax.sql.*;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.Level;

/*
 * An AuthAdminBean can appear to be modelled after a User. It has fields to store data that
 * are read from the database and fields that are properties for jsp interactions.
 * Sometimes it holds meta-properties like the list of all users for jsp purposes like
 * selecting a user from a list of users. That data is usually kept in the results member.
 * The results member is also used internally to temporary store data from the database awaiting
 * post processing of the AuthAdminBean instance itself.
 * If it gets more complex a refactoring could become appropriate.
 *
 */
/**
 * <p>AuthAdminBean class.</p>
 *
 * @author Carsten Schulz
 * @version $Id: $
 */
public class AuthAdminBean {
        
        private static Logger logger = LogManager.getLogger(AuthAdminBean.class);


        //TODO: externalize and factor out all names in strings...
        private final static String TBL_USERS = "Users"; //name of user table
        private final static String TBL_ROLES = "Roles"; //name of role able
        // I am in favor of creating unique Strings especially for constant values....
        private final static String ROLE_AUTH  = "authenticated".intern();
        private final static String ROLE_SUPER = Access.SUPERUSER_ROLE_NAME;
        private final static String LABEL_ADMIN  = "Administrator".intern();
        private final static String LABEL_AUTH   = "Authenticated".intern();
        private final static String LABEL_ANONYM = "Anonymous".intern();
        private final static String[] INTERNAL_ROLE_LABELS={LABEL_AUTH, LABEL_ANONYM};

        static Iterable<Role> rRoles = null;
        
        HashMap<String, User>   rdfUsers = null;
        User[]           sortedUsers = null;
        HashSet<String> rdbUsers     = null;
        int          rUidx           = 0; //current index in rdfUsers
        User         rUser           = null;
        List<String> rURolesAsLabels = null;

    // These are parameters for/from the UI...
        String username  = "";
    String password  = "";
    String password2 = "";
    String firstName = "";
    String lastName  = "";
    String mbox      = "";
    String uri       = "";
    String backupDir = "";

    String[] cbox  = null;
    String remoteUser = "";
    boolean remoteIsSuperuser = false;
    String[] roles = new String[0]; // Array of roles from the UI (as opposed to from repository user)
    HttpServletRequest request = null;


    String delimiter=",";
    ArrayList<String> results   = new ArrayList<String>();
    ArrayList<String> messages  = new ArrayList<String>();
    ArrayList<String> errors    = new ArrayList<String>();



    /**
     * <p>Constructor for AuthAdminBean.</p>
     */
    public AuthAdminBean(){
        super();
        logger.setLevel(Level.DEBUG);
    }
    
    /**
     * <p>Setter for the field <code>username</code>.</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setUsername( String value ){
        username = value;
    }
    /**
     * <p>Setter for the field <code>password</code>.</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setPassword( String value ){
        password = value;
    }
    /**
     * <p>Setter for the field <code>password2</code>.</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setPassword2( String value ){
        password2 = value;
    }
    /**
     * <p>Setter for the field <code>firstName</code>.</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setFirstName( String value ){
        firstName = value;
    }
    /**
     * <p>Setter for the field <code>lastName</code>.</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setLastName( String value ){
        lastName = value;
    }
    /**
     * <p>Setter for the field <code>mbox</code>.</p>
     *
     * @param value a {@link java.lang.String} object.
     */
    public void setMbox( String value ){
        mbox = value;
    }
    private void setRUser(User value){
        rUser=value;
    }
    /**
     * <p>Setter for the field <code>backupDir</code>.</p>
     *
     * @param name a {@link java.lang.String} object.
     */
    public void setBackupDir(String name){
        backupDir=name;
    }
    /**
     * <p>Getter for the field <code>backupDir</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getBackupDir(){
        return backupDir;
    }
    /**
     * <p>Setter for the field <code>request</code>.</p>
     *
     * @param value a {@link javax.servlet.http.HttpServletRequest} object.
     */
    public void setRequest( HttpServletRequest value ){
        request = value;
    }
    /**
     * <p>Setter for the field <code>cbox</code>.</p>
     *
     * @param values an array of {@link java.lang.String} objects.
     */
    public void setCbox( String[] values ){
        cbox = values;
    }
    /**
     * <p>Setter for the field <code>roles</code>.</p>
     *
     * @param list an array of {@link java.lang.String} objects.
     */
    public void setRoles(String[] list){
        logger.debug("@@@" + Arrays.asList(list).toString());
        roles = list;
    }
    /**
     * <p>Setter for the field <code>remoteUser</code>.</p>
     *
     * @param rid a {@link java.lang.String} object.
     */
    public void setRemoteUser(String rid){
        remoteUser=rid;
    }
    /**
     * <p>Getter for the field <code>remoteUser</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getRemoteUser(){
        return remoteUser;
    }
    /**
     * <p>Setter for the field <code>remoteIsSuperuser</code>.</p>
     *
     * @param flag a boolean.
     */
    public void setRemoteIsSuperuser(boolean flag){
        remoteIsSuperuser=flag;
    }
    /**
     * <p>Getter for the field <code>remoteIsSuperuser</code>.</p>
     *
     * @return a boolean.
     */
    public boolean getRemoteIsSuperuser(){
        return remoteIsSuperuser;
    }
    /**
     * <p>getIsSuperuser</p>
     *
     * @return a boolean.
     */
    public boolean getIsSuperuser(){
        List<String> labels= getRU_roleLabelListIntern();
        if (labels.contains(LABEL_ADMIN)) return true;
        return false;
    }
    /**
     * <p>getShouldBecomeSuperuser</p>
     *
     * @return a boolean.
     */
    public boolean getShouldBecomeSuperuser(){
        if (roles==null) return false;
        
        String s=null;
        for (Iterator<String> j = Arrays.asList(roles).iterator(); j.hasNext(); ){
                s=j.next();
                if (s.intern() == LABEL_ADMIN) return true;
        }
        return false;
    }
/*
    public boolean xxxShouldBecomeSuperuser(){
        if(cbox==null){
                return false;
        }
        for(int i=0; i<cbox.length; i++){
                if(cbox[i]!=null){
                                if(cbox[i].equals("Superuser")){
                                        return true;
                                }
                }
        }
        return false;
    }
 */

    // is the currently selected user active?
    /**
     * <p>isUserActive</p>
     *
     * @return a boolean.
     */
    public boolean isUserActive(){
        // Busines logic: Only if a User is "Authenticated", the user is "active"
        // If not Authenticated, there should be no record in the authentication
        // database. Even if the User has the Administrator/superuser role!!
        if (getRU_roleLabelListIntern().contains(LABEL_AUTH)) return true;
        return false;
    }
    // is the passed User active?
    // (ought to be in User.class)
    /**
     * <p>isUserActive</p>
     *
     * @param u a {@link org.eaglei.repository.User} object.
     * @return a boolean.
     */
    public boolean isUserActive(User u){
        // Busines logic: Only if a User is "Authenticated", the user is "active"
        // If not Authenticated, there should be no record in the authentication
        // database. Even if the User has the Administrator/superuser role!!
        Role[] rarr=u.getRoles();
        for(int i=0; i<rarr.length; i++){
                if(LABEL_AUTH.equals(rarr[i].getLabel())) return true;
        }
        return false;
    }
    private boolean isNotInternalRole(String label){
        return (! (Arrays.asList(INTERNAL_ROLE_LABELS).contains(label)));
    }
    
    /**
     * <p>getUserConfirmed</p>
     *
     * @return a boolean.
     */
    public boolean getUserConfirmed(){
        if(cbox==null){
                return false;
        }
        for(int i=0; i<cbox.length; i++){
                if(cbox[i]!=null){
                        if(cbox[i].equals("DeleteConfirmed")){
                                return true;
                        }
                }
        }
        return false;
    }
    /**
     * <p>getSymbol_RoleSuperuser</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getSymbol_RoleSuperuser(){
        return ROLE_SUPER;
    }

    
    // no setter for results as results get populated exclusively by execution towards database!!

    /**
     * <p>Getter for the field <code>username</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getUsername(){
        return username;
    }
    /**
     * <p>Getter for the field <code>password</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getPassword(){
        return password;
    }
    /**
     * <p>Getter for the field <code>password2</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getPassword2(){
        return password2;
    }
    /**
     * <p>Getter for the field <code>firstName</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getFirstName(){
        return firstName;
    }
    /**
     * <p>Getter for the field <code>lastName</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getLastName(){
        return lastName;
    }
    
    /**
     * <p>getAllUsers</p>
     *
     * @return a {@link java.util.ArrayList} object.
     */
    public ArrayList<String> getAllUsers(){
        HashSet<String> union=new HashSet(rdfUsers.keySet());
        union.addAll(rdbUsers);
        ArrayList<String> usrlist = new ArrayList<String>(union.size());
        for (String s : union){
                usrlist.add(s);
        }
        return usrlist;
    }
    
    /**
     * <p>getAsHTML_RUserFirstName</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getAsHTML_RUserFirstName(){
        if (rUser!=null){
                return rUser.getFirstName()==null ? "" : rUser.getFirstName();
        }
        return "";
    }
    /**
     * <p>getAsHTML_RUserLastName</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getAsHTML_RUserLastName(){
        if (rUser!=null){
                return rUser.getLastName()==null ? "" : rUser.getLastName();
        }
        return "";
    }
    /**
     * <p>getAsHTML_RUserMbox</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getAsHTML_RUserMbox(){
        if (rUser!=null){
                return rUser.getMbox()==null ? "" : rUser.getMbox();
        }
        return "";
    }
    private int getDisplayListSize(){
        return 10;
    }
    /**
     * <p>getBACKUPList</p>
     *
     * @return a {@link java.util.ArrayList} object.
     */
    public ArrayList<String> getBACKUPList(){
        File bckupDir = null;
        try{
                bckupDir=DataRepository.getInstance().getBackupDirectory();
        } catch (IOException e){
                
        }
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(bckupDir.list()));
        
        return names;
    }
    
    /**
     * <p>scrollNext</p>
     */
    public void scrollNext(){
        int lgth=getDisplayListSize();
        rUidx = (getAllUsers().size()>rUidx+lgth) ? rUidx+lgth : rUidx;
    }
    /**
     * <p>scrollPrev</p>
     */
    public void scrollPrev(){
        int lgth=getDisplayListSize();
        rUidx = (rUidx-lgth)>0 ? rUidx-lgth : 0;
    }
    /**
     * <p>getHtmlTable_UserList</p>
     *
     * @param count a int.
     * @return a {@link java.lang.String} object.
     */
    public String getHtmlTable_UserList(int count){

        String html = "<table border=\"1\"><tr><th>Username</th><th>First name</th><th>Last name</th></tr>\n";
        String uidString = null;
        
/*
        TreeSet<User> sUsers=new TreeSet<User>(new UserComparator());
        sUsers.addAll(rdfUsers.values());
        User[] sortedUsers=new User[(sUsers.size())];
        Iterator<User> it=sUsers.iterator();
        int idx=0;
        while(it.hasNext()){
                User u = it.next();
                sortedUsers[idx]=u;
                ++idx;
        }
*/
        // Get a list with all the usernames
        ArrayList<String> allUserNames = getAllUsers();
        Collections.sort(allUserNames);
        
        int end = ((rUidx+count)>allUserNames.size()) ? allUserNames.size() : (rUidx+count);
        logger.debug("Will create table of "+ count + " users starting at "+rUidx+" ending at "+end+" of "+(allUserNames.size()));
        for(int i=rUidx;i<end;i++){
                uidString=allUserNames.get(i);
            User u = rdfUsers.get(uidString);
            String uidHtmlString=uidString;

            // if not an rdbUser = inactive; display format for username italic
            if(rdbUsers.contains(uidString)){
                // Yes, this user is Authenticated!
                if (u==null){
                        //In RDB but not in RDF, created autside repository, valid if sysadmin ads admin user, mark bold...
                        uidHtmlString="<b>" + uidHtmlString + "</b>";
                } else {
                        //In RDB and in RDF, the "normal" case..
                }
            } else {
                //No, this user is not authenticated
                if (u==null){
                        //no RDF user
                        uidHtmlString="<i>" + uidHtmlString + "</i>";
                        logger.debug("Oops, encoutered userid that isnt in RDF and not inRDB" + uidString);
                } else {
                        // This user was retired, indicate by markup strikethrough
                        uidHtmlString="<del>" + uidHtmlString + "</del>";
                }
            }
                html=html + "<tr><td><a href=\"/repository/admin/updateUserIfc.jsp?username=" + uidString + "\">" + uidHtmlString + "</a></td>";
                
            if (u!=null){
                html=html + "<td>" + ppHtmlName(u.getFirstName()) + "</td>";
                html=html + "<td>" + ppHtmlName(u.getLastName()) + "</td></tr>\n";
            } else {
                // no rdf-user means only in RDB but not in RDF yet!
                html=html + "<td>(no rdf data available)</td>";
                html=html + "<td>(no rdf data available)</td></tr>\n";
            }
        }
        html=html + "<tr><th><a href=\"/repository/admin/selectUserIfc.jsp?scroll=prev\">prev</a></th><th/><th><a href=\"/repository/admin/selectUserIfc.jsp?scroll=next\">next</a></th></tr></table>";
        return html;
    }
    
    private String ppHtmlName(String aString){
        if (aString == null) return "(not set)";
        if (aString.isEmpty()) return "(not set)";
        return aString;
    }

    /**
     * <p>getHtmlUserRolesCheckboxes</p>
     *
     * @param isNew a boolean.
     * @return a {@link java.lang.String} object.
     */
    public String getHtmlUserRolesCheckboxes(boolean isNew){
        if (rRoles==null){
                return "<i>No Roles defined!</i>";
        }
        if ((! isNew) && rUser==null){
                return "<i>No User set!</i>";
        }
        // The roles labeled "Authenticated" and "Anonymous" are virtual roles for internal use only....
        Role r = null;
        String html = "";
        String rLabel=null;
        for (Iterator<Role> j = rRoles.iterator(); j.hasNext(); ){
                r=j.next();
                rLabel=r.getLabel();
                if (isNotInternalRole(rLabel)) {
                        html = html + "<tr> <td align=\"right\">" + rLabel + ":</td> <td align=\"left\">";
                        html = html + " <input type=\"checkbox\" ";
                        if (! isNew){
                                if (rUser.hasRoleP(r)){
                                        html = html + " checked=\"yes\"";
                                }
                        }
                        html = html + " name=\"roles\" value=\"" + rLabel + "\"";
                        if (! getRemoteIsSuperuser()){
                                // should fail inside the rdf data access layer, but we should disable the controls too!
                                html=html + " disabled=\"true\" ";
                        }
                        html = html + "/> </td> </tr>";
                }
        }
        return html;
    }
    
    private boolean isValidPassword(String input){
        return (input.matches("[a-zA-z0-9@#$%?&\\-_]*"));
    }
    private boolean isValidUsername(String input){
        return (input.matches("[a-zA-z0-9_]*"));
    }
    
    // Returns the current repository Users roles as list of labels of internalised Strings
    /**
     * <p>getRU_roleLabelListIntern</p>
     *
     * @return a {@link java.util.List} object.
     */
    protected List getRU_roleLabelListIntern(){
        if (rUser==null) return null;
        if (rURolesAsLabels!= null) return rURolesAsLabels;
        Role[] rur=rUser.getRoles();
        int l =rur.length;
        rURolesAsLabels=new ArrayList(l);
        for (int i=0;i<l;i++){
                rURolesAsLabels.add(rur[i].getLabel().intern());
        }
        return rURolesAsLabels;
    }
    

    private String[] getRolesIntern(){
        if (roles==null) return null;
        int l = roles.length;
        String [] r = new String[l];
        for (int i=0;i<l;i++){
                r[i]=roles[i].intern();
        }
        return r;
    }
    
    /**
     * <p>Getter for the field <code>mbox</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getMbox(){
        return mbox;
    }
    /**
     * <p>getURI</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getURI(){
        if (rUser != null){
                return rUser.getURI().toString();
        }
        return "a problem occured!";
    }
    /**
     * <p>getRepoRoles</p>
     *
     * @return a {@link java.lang.Iterable} object.
     */
    public Iterable<Role> getRepoRoles(){
        return rRoles;
    }
    /**
     * <p>Getter for the field <code>request</code>.</p>
     *
     * @return a {@link javax.servlet.http.HttpServletRequest} object.
     */
    public HttpServletRequest getRequest(){
        return request;
    }
    /**
     * <p>Getter for the field <code>results</code>.</p>
     *
     * @return a {@link java.util.ArrayList} object.
     */
    public ArrayList<String> getResults(){
        return results;
    }
    /**
     * <p>Getter for the field <code>errors</code>.</p>
     *
     * @return a {@link java.util.ArrayList} object.
     */
    public ArrayList<String> getErrors(){
        return errors;
    }
    /**
     * <p>Getter for the field <code>messages</code>.</p>
     *
     * @return a {@link java.util.ArrayList} object.
     */
    public ArrayList<String> getMessages(){
        return messages;
    }
    private void clearMessages(){
        messages = new ArrayList<String>();
    }
    private void addMessage(String aString){
        //will not set but rather append...
        messages.add(aString);
    }

    private boolean executionSuccess(){
        return (getErrors().isEmpty());
    }
    private boolean errorsOccured(){
        return (! getErrors().isEmpty());
    }
    private void clearResults(){
        results = new ArrayList<String>();
    }
    private void addResult(String aString){
        results.add(aString);
    }
    private void clearErrors(){
        errors = new ArrayList<String>();
    }
    private void addError(String aString){
        //will not set but rather append...
        errors.add(aString);
    }
    private void clear(){
        clearErrors();
        clearMessages();
        clearResults();
    }
    /**
     * <p>resetUserlist</p>
     */
    public void resetUserlist(){
        HashMap<String, User>   rdfUsers = null;
        User[]           sortedUsers = null;
        HashSet<String> rdbUsers     = null;
        int          rUidx           = 0; //current index in rdfUsers
        User         rUser           = null;
        List<String> rURolesAsLabels = null;
    }
    /**
     * <p>reset</p>
     */
    public void reset(){
        resetCbox();
        uri=username=password=password2=firstName=lastName=mbox=remoteUser="";
        remoteIsSuperuser=false;
        roles=new String[0];
        rdfUsers=null;
        rUser=null;
        rURolesAsLabels=null;
        
    }
    /**
     * <p>resetCbox</p>
     */
    public void resetCbox(){
        cbox=null;
    }
    /**
     * <p>initRoles</p>
     *
     * @param request a {@link javax.servlet.http.HttpServletRequest} object.
     */
    public void initRoles(HttpServletRequest request){
        // Really late late initialization... due to restriction:
        // Can't initialize Roles without a repository connection.
        // since the repo connection is initialized by a servlet filter, we can't initialize without the first
        // request comming in from the user....
        if (rRoles == null){
                // all Roles from the repository...
                try {
                        rRoles = Role.findAll(request);
                } catch (ServletException e){
                        logger.warn("Couldn't retrieve Roles!", e);
                }
        }
    }
    
    
    /* ========================================================================
     * ========================================================================
     * Application layer of this bean....
     */
    /* @TODO: It would be nifty if the concept of a BlockContext/anonymous
     * function expressions was part of the java language. Transaction
     * processing could get resolved rather nicely by that.
     * But it is not, so I should do some more thinking on how to code the
     * application logic without repeating the always constant transaction
     * control sequence. Maybe the transactions could get implemented as
     * (an) inner class(es) that get passed into a generic transaction
     * method....
     */
    
    /**
     * <p>executeAdHocSQL</p>
     *
     * @return a boolean.
     */
    public boolean executeAdHocSQL(){
        Transaction transaction = (new Transaction() {
                public void execute(Connection c) throws SQLException {
                        // username is used to store the expression....
                        String expr=getUsername();
                        sqlExpression(c, expr);
                }
        });
        return execute(transaction);
    }

    
    /* Method postUpdateUser()
     * Bean method that attempts user creation from the data that is
     * set in the bean.
     * Returns true if user was created successfully and false if
     * something went wrong.
     */
    /**
     * <p>postUpdateUser</p>
     *
     * @return a boolean.
     */
    public boolean postUpdateUser(){
        if (    (! getRemoteIsSuperuser()) &&
                        (!remoteUser.equals(getUsername()))){
                addError("Only a user him or herself or superuser may update user information!");
                return false;
        }
        clear();
        if(! selectUser()){
                return false;
        }
        clear();
        if ((getPassword().intern()) != (getPassword2().intern())){
                addError("The passwords do not match!");
                return false;
        }
        
        // make sure roles are initialized REPO-76....
                if (getRepoRoles() == null)  initRoles(getRequest());
        
        Transaction transaction = (new Transaction() {
                public void execute(Connection c) throws Exception {
                        String uName=getUsername();
                        String pWord=getPassword();
                        if (pWord.length()>0){
                                // ok, change password....
                                sqlChangePassword(c, uName, pWord);
                                addMessage("Changed password of user \"" + uName + "\"!");
                        }
                        if (getIsSuperuser()!= getShouldBecomeSuperuser()){
                                if (getShouldBecomeSuperuser()){
                                        sqlGrantSuper(c,uName);
                                        addMessage("Granted role \"Administrator\" to user \"" + uName + "\"!");
                                } else {
                                        sqlRevokeSuper(c, uName);
                                        addMessage("Revoked role \"Administrator\" from user \"" + uName + "\"!");
                                }
                        }


                        // so far so good, now operate on the tripplestore...
                        boolean flag=false;
                        if (! getFirstName().equals("")){
                                if (! getFirstName().equals(rUser.getFirstName())){
                                        logger.debug("@ setting "+uName+"s first name to:"+getFirstName());
                                        rUser.setFirstName(getRequest(), getFirstName());
                                        addMessage("Changed first name for user " + uName);
                                        flag=true;
                                }
                        }
                        if (! getLastName().equals("")){
                                if (! getLastName().equals(rUser.getLastName())){
                                        logger.debug("@setting "+uName+"s last name to:"+getLastName());
                                        rUser.setLastName(getRequest(), getLastName());
                                        addMessage("Changed surname for user " + uName);
                                        flag=true;
                                }
                        addError("Only a superuser or the user him- or herself may update user information!");
                }
                        if (! getMbox().equals("")){
                                if (! getMbox().equals(rUser.getMbox())){
                                        logger.debug("@setting "+uName+"s mbox name to:"+getMbox());
                                        rUser.setMbox(getRequest(), getMbox());
                                        addMessage("Changed mbox for user " + uName);
                                        flag=true;
                                }
                        }

                        // only an admin may manage roles, this should fail in the RDF data access layer,
                        // but we will also enforce it here (also saves some CPU cycles)....
                        if(getRemoteIsSuperuser()){
                                List<String> uiLabels = Arrays.asList(getRolesIntern());
                                Role r = null;
                                String label=null;
                                logger.debug("Roles from ui:" + uiLabels.toString());
                                logger.debug("Roles from repo:" + getRU_roleLabelListIntern().toString());
                                // Traverse all roles....
                                for (Iterator<Role> j = getRepoRoles().iterator(); j.hasNext(); ){
                                        r=j.next();
                                        label=r.getLabel();
                                        // ignore internal roles
                                        if (isNotInternalRole(label)){
                                                if (rUser.hasRoleP(r)){
                                                // User currently has role...
                                                        if (! uiLabels.contains(label)){
                                                                // but UI labels doesn't contain it anymore...
                                                                rUser.removeRole(request, r);
                                                                addMessage("Removed role "+r.getLabel()+" from user " + uName);
                                                                flag=true;
                                                        }
                                                } else {
                                                        //has not role but is checked: addition requested....
                                                        if (uiLabels.contains(label)){
                                                                rUser.addRole(request, r);
                                                                addMessage("Added role "+r.getLabel()+" to user " + uName);
                                                                flag=true;
                                                        }
                                                }
                                        }
                                }
                        }

                        if (flag){
                                rUser.update(getRequest());
                                logger.debug("Updated user "+uName);
                        }
                }
        });
        try {
                return execute(transaction);
        } finally {
                reset();
                resetUserlist();
        }
    }
    
    /**
     * <p>postRetireUser</p>
     *
     * @return a boolean.
     */
    public boolean postRetireUser(){
        clear();
        // Password validation....
        if (! getUserConfirmed()){
                addError("User retirement was not confirmed!");
                return false;
        }
        // ...data checks out, let's talk to the database...
        /* Java does not sport anonymous function expressions.
         * Anonymous inner classes are somewhat similar though,
         * well, however one decides to look at this, an anonymous
         * inner class of the Transaction interface allows us to
         * create a lightweight unit of code that can be executed
         * within the context of its creator.
         * We could think of leaving transaction objects allocated.
         */
        Transaction transaction = (new Transaction() {
                public void execute(Connection c) throws SQLException {
                        String uName = getUsername();
                        sqlDeleteUserFromRoles(c, uName);
                        sqlDeleteUser(c, uName);
                        addMessage("User \"" + uName + "\" deleted!");
                }
        });
        boolean result=execute(transaction);
        reset();
        resetUserlist();
        return result;
    }
    
    /**
     * <p>postCreateUser</p>
     *
     * @return a boolean.
     */
    public boolean postCreateUser(){
        clear();
        // 1.) validation of data....
        String pwd = getPassword().intern();
        if ((pwd ==null)||(getUsername()==null)||pwd.equals("")||getUsername().equals("")) {
                addError("Neither username nor passwords may be empty!");
                return false;
        }
        if (pwd != getPassword2().intern()){
                addError("The passwords do not match!");
                return false;
        }
        if(! isValidPassword(pwd)){
                addError("Invalid characters in password!");
                return false;
        }
        String user = getUsername();
        if(! isValidUsername(user)){
                addError("Invalid characters in username!");
                return false;
        }
        
                if (getRepoRoles() == null)  initRoles(getRequest());
                
        // ...data checks out, let's talk to the database...
        /* An annonymous inner class of the Transaction interface allows
         * us to create a lightweight unit of code that can be executed
         * within the context of its creator.
         */
        Transaction transaction = (new Transaction() {
                public void execute(Connection c) throws SQLException, ServletException {
                        String uName=getUsername();
                        String pWord=getPassword();
                        sqlCreateUser(c, uName, pWord);
                        sqlGrantAuth (c, uName);
                        
                                // so far so good, now operate on the tripplestore...
                                rUser = User.create(getRequest(), uName);
                                if (getFirstName()!=null){
                                        if (! getFirstName().equals("")){
                                                logger.debug("@ setting "+uName+"s first name to:"+getFirstName());
                                                rUser.setFirstName(getRequest(), getFirstName());
                                                addMessage("Set first name for user " + uName);
                                        }
                                }
                                if (getLastName()!=null) {
                                        if (! getLastName().equals("")){
                                                logger.debug("@setting "+uName+"s last name to:"+getLastName());
                                                rUser.setLastName(getRequest(), getLastName());
                                                addMessage("Set surname for user " + uName);
                                        }
                                }
                                if (getMbox()!=null){
                                        if(! getMbox().equals("")){
                                                logger.debug("@setting "+uName+"s mbox name to:"+getMbox());
                                                rUser.setMbox(getRequest(), getMbox());
                                                addMessage("Set mbox for user " + uName);
                                        }
                                }

                                List<String> labels = Arrays.asList(getRolesIntern());
                                Role r = null;
                                for (Iterator<Role> j = getRepoRoles().iterator(); j.hasNext(); ){
                                        r=j.next();
                                        //has not role but is checked: addition requested....
                                        if (labels.contains(r.getLabel())){
                                                rUser.addRole(request, r);
                                                addMessage("Added role "+r.getLabel()+" to user " + uName);
                                        }
                                }

                                rUser.update(getRequest());
                        
                        addMessage("User \"" + uName + "\" created!");
                }
        });
        return execute(transaction);
    }
    

    /* Method selectUser()
     * Bean method that reads user all data from db to populate
     * web page for management purposes.
     * Returns true if user was created successfully and false if
     * something went wrong.
     */
    /**
     * <p>selectUsers</p>
     *
     * @return a boolean.
     */
    public boolean selectUsers(){
        clear();

        Transaction transaction = (new Transaction() {
                public void execute(Connection c) throws SQLException, ServletException {
                        // getting all users from the repository...
                        Iterable<User> userList = User.findAll(request);
                        User u = null;
                        rdfUsers=new HashMap<String, User>();
                        for (Iterator<User> j = userList.iterator(); j.hasNext(); ){
                                u=j.next();
                                rdfUsers.put(u.getUsername().intern(), u);
                        }
                        sqlFetchUsers(c);
                        computeRdbUserList();
                }
        });
        return execute(transaction);
    }
    
    private void computeRdbUserList(){
        rdbUsers = new HashSet<String>();
        String s=null;
        for (Iterator<String> it = getResults().iterator(); it.hasNext(); ){
                s=it.next().intern();
                rdbUsers.add(s);
        }
    }

    
    /* Method selectUser()
     * Bean method that reads user all data from db to populate
     * web page for management purposes.
     * Returns true if user was created successfully and false if
     * something went wrong.
     */
    /**
     * <p>selectUser</p>
     *
     * @return a boolean.
     */
    public boolean selectUser(){
        clear();
        String user = getUsername();

        logger.debug("Selected user: " + user + " remote user: " + getRemoteUser() + (getRemoteIsSuperuser() ? " <- admin" : " <- not admin"));
        if( (! user.equals(getRemoteUser())) &&
                        (! getRemoteIsSuperuser())){
                addError("Only a superuser or the user him- or herself may update user information!");
                return false;
        }

        Connection c = null;
        try {
                c = checkoutConnection();
                sqlFetchRoles(c, user);

                // so far so good, now operate on the tripplestore...
                User repoUser = User.findUsername(getRequest(), user);
                if (repoUser==null){
                        // ok, no RDF user, means user was added to RDF outside of repository by an admin
                        // and user didn't log in yet in which case user would have been autocreated.
                        //so we will just add the user now....
                        try {
                                logger.debug("Didn't find "+user+" in RDF, creating...");
                                repoUser=User.create(getRequest(), user);
                                repoUser.update(getRequest());
                                resetUserlist();
                        } catch (ServletException e){
                        addError("Encountered exception when attempting to add user to RDF: " + e.getMessage());
                                return false;
                        }
                }
                setRUser(repoUser);
                initRoles(getRequest());
        } catch (NamingException e) {
                addError(e.toString());
                return false;
        } catch (SQLException e){
                addError(e.toString());
                try {c.rollback();} catch (Exception e2){}
                return false;
        } catch(ServletException e) {
                addError("Exception occured: "+e.toString());
                try {c.rollback();} catch (Exception e2){}
                return false;
        } finally {
                if (c != null) {
                        try {c.close();} catch (SQLException e) {}
                        c = null;
                }
        }
        // ok!
        return true;
    }

    /**
     * <p>backupDB</p>
     *
     * @return a boolean.
     */
    public boolean backupDB(){
        clear();
        // Saving parameter by storing path in username....
        final String bakName = getBackupDir();
        if (! bakName.matches("[\\p{Alnum}[\\-/_]]*")){
                addError("Illegal characters in backup folder name! Name may only include alphanumeric characters.");
                return false;
        }
        Transaction transaction = new Transaction() {
                public void execute(Connection c) throws SQLException {
                        String backupPath="";
                        try {
                                backupPath = DataRepository.getInstance().getBackupDirectory().toString()+ File.separator + bakName;
                        } catch (java.io.IOException e){
                                addError(e.toString());
                        }
                        sqlBackupDB (c, backupPath);
                        addMessage("Backed up authentication data to: "+backupPath);
                }
        };
        return execute(transaction);
    }
    
    /* restoreDB()
     * experimental method for rollforward recovery attempt in case of corruption.
     * Will might not work since other threads might still be connected (Container and Pooling).
     * Still, one could try and see if it works. Corrupted files are hard to produce and then test...
     */
    /**
     * <p>restoreDB</p>
     *
     * @return a boolean.
     */
    public boolean restoreDB(){
        clear();
        // Saving parameter by storing path in username....
        String bakName = getBackupDir();
        String bakPath = null;
        try {
                bakPath=(DataRepository.getInstance().getBackupDirectory().toString());
        } catch (IOException e){
                logger.debug("Oops, caught IOException on restore: " + e.getMessage());
                addError(e.getMessage());
                return false;
        }
        String dbURL = "jdbc:derby:db" + File.separator + DataRepository.AUTH_DB_NAME +
                ";rollforwardrecoveryFrom=" + bakPath + File.separator +
                bakName + File.separator + DataRepository.AUTH_DB_NAME;
        logger.debug("Attempting restore from: " + dbURL);
        Connection c = null;
        try {
                c = DriverManager.getConnection(dbURL);
                addMessage("Restored Authentication Database from: " + bakPath + File.separator + bakName);
        } catch (SQLException e) {
                logger.debug("Oops, caught SQLException on restore: " + e.getMessage());
                addError(e.getMessage());
                return false;
        } finally {
                try {
                        c.close();
                } catch (SQLException e){}
        }
        return true;
    }


    /* ========================================================================
         * Internal utillity layer translating application logic into a
     * SQL expression String and passing it on for low level execution.
     * This is strictly one method per operation/statement mapping, aggregation
     * and flow control happens in the layers above.
     */
        private void sqlExpression(Connection c, String sqlExp)
                        throws SQLException {
                execute(c, sqlExp);
        }

        private void sqlBackupDB(Connection c, String backupfilePath)
                        throws SQLException {String sqlExp = "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE('" + backupfilePath + "')";
                execute(c, sqlExp);
        }

        private void sqlFetchUsers(Connection c)
                        throws SQLException {
                String sqlExp =  "SELECT Username FROM " + TBL_USERS;
                executeAndFetch(c, sqlExp);
        }
        
        private void sqlFetchUser(Connection c, String usr)
                        throws SQLException {
                String sqlExp =  "SELECT Username FROM " + TBL_ROLES + " WHERE Username='" + usr + "'";
                executeAndFetch(c, sqlExp);
        }
        private void sqlFetchRoles(Connection c, String usr)
                        throws SQLException {
                String sqlExp =  "SELECT Rolename FROM " + TBL_ROLES + " WHERE Username='" + usr + "'";
                executeAndFetch(c, sqlExp);
        }
        
        private void sqlCreateUser(Connection c, String usr, String pwd)
                        throws SQLException {
                String sqlExp =  "INSERT INTO " + TBL_USERS + " VALUES ('" + usr + "', '" + pwd + "')";
                execute(c, sqlExp);
        }
        private void sqlChangePassword(Connection c, String usr, String pwd)
                        throws SQLException {
                String sqlExp =  "UPDATE " + TBL_USERS + " SET Password='" + pwd + "' WHERE Username='" + usr + "'";
                execute(c, sqlExp);
        }
        private void sqlDeleteUser(Connection c, String usr)
                        throws SQLException {
                String sqlExp =  "DELETE FROM " + TBL_USERS + " WHERE Username = '" + usr + "'";
                execute(c, sqlExp);
        }
        private void sqlDeleteUserFromRoles(Connection c, String usr)
                        throws SQLException {
                String sqlExp =  "DELETE FROM " + TBL_ROLES + " WHERE Username = '" + usr + "'";
                execute(c, sqlExp);
        }
        private void sqlFetchPasswordForUser(Connection c, String usr)
                        throws SQLException {
                String sqlExpr = "SELECT Password FROM " + TBL_USERS + " WHERE Username='" + usr + "'";
                executeAndFetch(c, sqlExpr);
        }

        private void sqlGrantAuth(Connection c, String usr)throws SQLException {
                execute(c, sqlExprGrantRole(ROLE_AUTH ,usr));
        }
        private void sqlGrantSuper(Connection c, String usr)throws SQLException {
                execute(c, sqlExprGrantRole(ROLE_SUPER ,usr));
        }
        private String sqlExprGrantRole(String role, String usr) {
                return "INSERT INTO " + TBL_ROLES + " VALUES ('" +  role + "', '" + usr + "')";
        }

        private void sqlRevokeAuth(Connection c, String usr)throws SQLException {
                execute(c, sqlExprRevokeRole(ROLE_AUTH ,usr));
        }
        private void sqlRevokeSuper(Connection c, String usr)throws SQLException {
                execute(c, sqlExprRevokeRole(ROLE_SUPER ,usr));
        }
        private String sqlExprRevokeRole(String role, String usr){
                return "DELETE FROM " + TBL_ROLES + " WHERE (rolename = '" +  role + "') AND (Username = '" + usr + "')";
        }


        /* ========================================================================
         * ========================================================================
         * Generic low level plumbing section:
         * ------------------------------------------------------------------------
         */
        

    /* Method checkoutConnection()
     * Checks out a database connection from the connection pool.
     *
     */
    private Connection checkoutConnection() throws NamingException, SQLException {
                Context initContext = new InitialContext();
                Context envContext  = (Context)initContext.lookup("java:/comp/env");
                DataSource ds = (DataSource)envContext.lookup("jdbc/eaglei");
                Connection c = ds.getConnection();
                return c;
    }
        
    /* Method executeTransaction(Transaction aTransaction)
     * Generic method that guards the execution of a Transaction class
     * within the context of a database transaction.
     * If the aTransaction throws a SQLException, the method roles
     * back the transaction, if it does not, it commits the transaction.
     *
     * Returns true when it comits, false when it roles back.
     */
    private boolean execute(Transaction transaction){
        clear();
        Connection c = null;
        try {
                c = checkoutConnection();
                c.setAutoCommit(false);
                transaction.execute(c);
                c.commit();
        } catch (NamingException e) {
                addError(e.toString());
                return false;
        } catch (SQLException e){
                addError(e.toString());
                try {c.rollback();} catch (Exception e2){
                        logger.warn("Caught exception on rolling back:"+e2);
                }
                return false;
        } catch (Exception e){
                e.printStackTrace();
                addError(e.toString());
                try {c.rollback();} catch (Exception e2){
                        logger.warn("Caught exception on rolling back:"+e2);
                }
                return false;
        } finally {
                if (c != null) {
                        try {c.close();} catch (SQLException e) {
                                logger.warn("Caught exception on rolling back:"+e);
                        }
                }
        }
        // ok!
        return true;
    }

        
    /*
     * Executes a sql expression on the Connection that is passed in.
     * Cleans up everything it allocates.
     */
    private void executeAndFetch(Connection conn, String sqlExpression)
    throws SQLException{
        Statement stmt = null;
        ResultSet rs = null;
        logger.debug("Executing for resulttuple: \"" + sqlExpression + "\"");
        try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlExpression);
                fetch(rs);
                rs.close();
                stmt.close();
        } finally {
                // Always make sure result sets and statements are closed!
                if (stmt != null) {
                        try {
                                stmt.close();
                        } catch (SQLException e) {
                                logger.warn("Caught exception on closing statement:"+e);
                        }
                        stmt = null;
                }
                if (rs != null) {
                        try {
                                rs.close();
                        } catch (SQLException e) {
                                logger.warn("Caught exception on closing result set:"+e);
                        }
                        rs = null;
                }
        }
    }

    private int execute(Connection conn, String sqlExpression)
    throws SQLException {

        Statement stmt = null;
        int rc = 0;
        logger.debug("Executing for update: \"" + sqlExpression + "\"");
        try {
                stmt = conn.createStatement();
                rc = stmt.executeUpdate(sqlExpression);
                logger.debug(stmt.getUpdateCount() + " rows updated!");
                stmt.close();
        } finally {
                // Always make sure statements are closed!
                if (stmt != null) {
                        try {
                                stmt.close();
                        } catch (SQLException e) {
                                logger.warn("Caught exception on closing statement:"+e);
                        }
                }
        }
        return(rc);
    }
    /* Method fetch(ResultSet rs)
     * Assumption: We only work on String datatypes!
     * Otherwise generic fetching of (ONE) aResultSet based on it's meta data.
     * The rows are 'delimiter' separated printed onto one String per row
     * and added to the 'results' member.
     *
     */
    private void fetch (ResultSet rs)throws SQLException {
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int noc = rsMetaData.getColumnCount();
        logger.debug("result set column count=" + noc);

        for (int i = 1; i <= noc; i++) {
                String[] row = new String[noc];
                logger.trace("column MetaData ");
                logger.trace("column number " + i);
                // indicates the designated column's normal maximum width in
                // characters
                logger.trace(rsMetaData.getColumnDisplaySize(i));
                // gets the designated column's suggested title
                // for use in printouts and displays.
                logger.trace(rsMetaData.getColumnLabel(i));
                // get the designated column's name.
                logger.trace(rsMetaData.getColumnName(i));

                // get the designated column's SQL type.
                rsMetaData.getColumnType(i);
                logger.trace(rsMetaData.getColumnType(i));

                // get the designated column's SQL type name.
                //System.out.println(rsMetaData.getColumnTypeName(i));

                // get the designated column's class name.
                //System.out.println(rsMetaData.getColumnClassName(i));

                // get the designated column's table name.
                //logger.trace(rsMetaData.getTableName(i));

                // get the designated column's number of decimal digits.
                //System.out.println(rsMetaData.getPrecision(i));

                // gets the designated column's number of
                // digits to right of the decimal point.
                //System.out.println(rsMetaData.getScale(i));

                // indicates whether the designated column is
                // automatically numbered, thus read-only.
                //logger.trace("isAutoIncrement: " + rsMetaData.isAutoIncrement(i));

                // indicates whether the designated column is a cash value.
                //logger.trace(rsMetaData.isCurrency(i));

                // indicates whether a write on the designated
                // column will succeed.
                //logger.trace("isWritable: " + rsMetaData.isWritable(i));

                // indicates whether a write on the designated
                // column will definitely succeed.
                //logger.trace("isDefinitelyWritable:" + rsMetaData.isDefinitelyWritable(i));

                // indicates the nullability of values
                // in the designated column.
                //logger.trace("isNullable:" + rsMetaData.isNullable(i));

                // Indicates whether the designated column
                // is definitely not writable.
                //logger.trace("isReadOnly:" + rsMetaData.isReadOnly(i));

                // Indicates whether a column's case matters
                // in the designated column.
                //logger.trace("isCaseSensitive: " + rsMetaData.isCaseSensitive(i));

                // Indicates whether a column's case matters
                // in the designated column.
                //logger.trace("isSearchable: " + rsMetaData.isSearchable(i));

                // indicates whether values in the designated
                // column are signed numbers.
                //logger.trace("isSigned: " + rsMetaData.isSigned(i));

                // Gets the designated column's table's catalog name.
                //logger.trace("getCatalogName: " + rsMetaData.getCatalogName(i));

                // Gets the designated column's table's schema name.
                //logger.trace("getSchemaName: " + rsMetaData.getSchemaName(i));
        }

        ArrayList<String[]> result = new ArrayList<String[]>();
        while(rs.next()){
                StringBuffer row = new StringBuffer();
                String field=null;
                for (int i = 1; i <= noc; i++) {
                        field=rs.getString(i);
                        if (i>1) {row.append(delimiter);};
                        row.append(field);
                }
                addResult(row.toString());
        }
    }
        
    /**************************************************************************
     ********************* Inner Classes and Interfaces ***********************
     **************************************************************************
     */
    

    /* Interface Transaction
     * Interface that annonymous inner classes will have to implement to
     * be executed as a transaction.
     */
    interface Transaction {
        void execute(Connection c) throws Exception;
    }
    
    public class UserComparator implements Comparator<User> {
        public int compare (User a, User b){
                return String.CASE_INSENSITIVE_ORDER.compare(a.getUsername(), b.getUsername());
        }
    }

}
