/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.inferencer.MinimalInferencer;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.openrdf.sail.nativerdf.NativeStore;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataRepository {
    private static Logger log = LogManager.getLogger(DataRepository.class);
    public static final String AUTH_DB_NAME = "eagle-i-users.derby";
    private static final String SCTX_REPOSITORY = "org.eaglei.repository.SesameRepository";
    private static final String SCTX_GENERATION = "org.eaglei.repository.Generation";
    private static final String CONFIG_NAMESPACE = "eaglei.repository.namespace";
    private static final String CONFIG_LOGDIR = "eaglei.repository.log.dir";
    private static final String CONFIG_SESAMEDIR = "eaglei.repository.sesame.dir";
    public static final String CONFIG_TITLE = "eaglei.repository.title";
    public static final String CONFIG_INSTANCE_XSLT = "eaglei.repository.instance.xslt";
    public static final String CONFIG_INSTANCE_CSS = "eaglei.repository.instance.css";
    private static final String REPO_HOME = "org.eaglei.repository.home";
    private static final String BACKUP_HOME = "org.eaglei.repository.backup";
    private static final Map<URI, String> graphInitFile = new HashMap();
    private ServletContext servletContext = null;
    private String defaultNamespace = null;
    private Configuration configuration = null;
    private Properties buildProperties = null;
    private Date lastModified = new Date();
    private static DataRepository instance;

    public static DataRepository getInstance() {
        return instance;
    }

    private static void printError(String msg) {
        System.err.println("***ERROR*** (at " + new Date().toString() + ") eagle-i DataRepository: " + msg);
    }

    private static void printInfo(String msg) {
        System.err.println("***INFO*** (at " + new Date().toString() + ") eagle-i DataRepository: " + msg);
    }

    public static void initialize(ServletContext sc) {
        if (instance == null) {
            try {
                instance = new DataRepository(sc);
                instance.finishInitialize();
            }
            catch (Exception e) {
                DataRepository.printError((String)("Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:" + e.toString()));
                log.fatal((Object)"Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:", (Throwable)e);
            }
        } else {
            log.fatal((Object)"Initialize was called after DataRepository already initialized!");
        }
    }

    public DataRepository(ServletContext sc) {
        this.servletContext = sc;
    }

    public void finishInitialize() throws IOException, OpenRDFException {
        File sesDir;
        File pf;
        File home = this.getHomeDirectory();
        DataRepository.printInfo((String)("Configuring with Eagle-I Repository Home dir = " + home.toString()));
        if (!home.exists()) {
            if (!home.mkdirs()) {
                DataRepository.printError((String)("Failed to create repository home directory, configured path = " + home));
                DataRepository.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
            }
        } else if (!home.isDirectory()) {
            DataRepository.printError((String)("Path configured as repository home is not a directory: " + home));
            DataRepository.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
        }
        if (!(pf = new File(home, "configuration.properties")).exists()) {
            try {
                Utils.copyStream((InputStream)this.getClass().getClassLoader().getResourceAsStream("default.configuration.properties"), (OutputStream)new FileOutputStream(pf));
            }
            catch (IOException e) {
                try {
                    pf.delete();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                DataRepository.printError((String)("Failed to copy default configuration file to repository home dir: " + e));
            }
        }
        try {
            log.debug((Object)("Loading configuration from file=" + pf));
            this.configuration = new PropertiesConfiguration(pf);
        }
        catch (Exception e) {
            DataRepository.printError((String)("Failed to read configuration, file=" + pf + ": " + e.toString()));
        }
        Properties lp = new Properties();
        Iterator pi = this.configuration.getKeys("log4j");
        while (pi.hasNext()) {
            String k = (String)pi.next();
            lp.setProperty(k, this.configuration.getString(k));
        }
        if (lp.containsKey("log4j.rootLogger")) {
            DataRepository.printInfo((String)"Setting up log4j with existing configuration properties");
            PropertyConfigurator.configure((Properties)lp);
        } else {
            DataRepository.printInfo((String)("Using default log4j setup, additional property count = " + lp.size()));
            this.setupDefaultLogging(home);
            if (lp.size() > 0) {
                PropertyConfigurator.configure((Properties)lp);
            }
        }
        String sesPath = this.configuration.getString("eaglei.repository.sesame.dir");
        File file = sesDir = sesPath == null ? new File(home, "sesame") : new File(sesPath);
        if (!sesDir.exists()) {
            sesDir.mkdirs();
        }
        SailRepository r = new SailRepository((Sail)new MinimalInferencer((NotifyingSail)new NativeStore(sesDir)));
        r.initialize();
        if (!r.isWritable()) {
            log.fatal((Object)"Sesame repo is not writable, this is going to cause trouble soon!");
        }
        this.servletContext.setAttribute("org.eaglei.repository.SesameRepository", (Object)r);
        log.info((Object)("Sesame Repository open, directory=" + sesDir.toString()));
        this.servletContext.setAttribute("org.eaglei.repository.Generation", (Object)new Integer(1));
        log.debug((Object)"Generation initialized to 1.");
        for (Map.Entry me : graphInitFile.entrySet()) {
            this.loadGraphIfEmpty((Repository)r, (URI)me.getKey(), (String)me.getValue());
        }
    }

    public void destroy(ServletContext sc) throws RepositoryException {
        Repository r = (Repository)sc.getAttribute("org.eaglei.repository.SesameRepository");
        sc.removeAttribute("org.eaglei.repository.SesameRepository");
        if (r != null) {
            r.shutDown();
            log.info((Object)"Sesame Repository closed.");
        }
        instance = null;
    }

    private void setupDefaultLogging(File home) throws IOException {
        String logPath = this.configuration.getString("eaglei.repository.log.dir");
        File logDir = logPath == null ? new File(home, "logs") : new File(logPath);
        DataRepository.printInfo((String)("Log file directory configured as: " + logDir.toString()));
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        RollingFileAppender a = new RollingFileAppender((Layout)new PatternLayout("%d{ISO8601} %p %c - %m%n"), new File(logDir, "default.log").toString());
        a.setName("default");
        BasicConfigurator.configure((Appender)a);
        Logger.getRootLogger().setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGraphIfEmpty(Repository r, URI graphURI, String resourcePath) throws RepositoryException, IOException, RDFParseException {
        RepositoryConnection rc = null;
        try {
            rc = r.getConnection();
            ValueFactory vf = r.getValueFactory();
            if (rc.size(new Resource[]{graphURI}) == 0L) {
                URL rurl = this.getClass().getClassLoader().getResource(resourcePath);
                if (rurl == null) {
                    log.error((Object)("Cannot find webapp resource at path=" + resourcePath));
                } else {
                    URLConnection ruc = rurl.openConnection();
                    long rdate = ruc.getLastModified();
                    log.debug((Object)("Loading graph=" + graphURI.toString() + " from URL=" + rurl.toString() + ", mod-date=" + rdate));
                    InputStreamReader is = new InputStreamReader(ruc.getInputStream());
                    if (is == null) {
                        log.error((Object)("Cannot open webapp resource at url=" + rurl));
                    } else {
                        rc.add((Reader)is, graphURI.toString(), RDFFormat.forFileName((String)resourcePath, (RDFFormat)RDFFormat.N3), new Resource[]{graphURI});
                        Provenance gp = new Provenance(graphURI);
                        gp.setProvenance(rc, DCTERMS.CREATED, (Value)Provenance.getDateTime((Date)new Date()));
                        gp.setProvenance(rc, DCTERMS.CREATOR, (Value)REPO.ROLE_SUPERUSER);
                        gp.setSource(rc, (Value)rc.getValueFactory().createURI(rurl.toString()), (Value)Provenance.getDateTime((Date)new Date(rdate)));
                        rc.commit();
                        log.info((Object)("Initialized the empty named graph, name=" + graphURI + ", from resource path=" + resourcePath));
                    }
                }
            }
        }
        finally {
            if (rc != null) {
                rc.close();
            }
        }
    }

    public Repository getSesameRepository() throws ServletException {
        Repository result = (Repository)this.servletContext.getAttribute("org.eaglei.repository.SesameRepository");
        if (result == null) {
            throw new ServletException("No RDF database connection, probably because of a failure in initialization.");
        }
        return result;
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            String cfg = this.configuration.getString("eaglei.repository.namespace");
            if (cfg != null) {
                log.debug((Object)("Got raw configured default namespace=" + cfg));
                try {
                    java.net.URI juri = new java.net.URI(cfg);
                    if (!juri.isAbsolute()) {
                        log.error((Object)("The configured namespace prefix must be an absolute URI: eaglei.repository.namespace = " + cfg));
                    } else if (juri.getPath() == null) {
                        log.error((Object)("The configured namespace prefix must include a path ending with a slash ('/'): eaglei.repository.namespace = " + cfg));
                    } else if (!juri.getPath().endsWith("/")) {
                        log.error((Object)("The configured namespace prefix must end with a slash ('/'): eaglei.repository.namespace = " + cfg));
                    } else {
                        String scheme = juri.getScheme();
                        if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) {
                            this.defaultNamespace = cfg;
                        } else {
                            log.error((Object)("The configured namespace prefix must be an absolute URI: eaglei.repository.namespace = " + cfg));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    log.error((Object)("The configured namespace prefix has illegal URI syntax: eaglei.repository.namespace = " + cfg + ": " + e));
                }
            }
            if (this.defaultNamespace == null) {
                try {
                    this.defaultNamespace = "http://" + InetAddress.getLocalHost().getHostName() + "/i/";
                }
                catch (UnknownHostException e) {
                    log.error((Object)"Failed to get hostname for default URI prefix", (Throwable)e);
                    this.defaultNamespace = "http://failed-to-get-local-host-name/i/";
                }
                if (cfg == null) {
                    log.warn((Object)"Default Namespace Prefix URI not configured.  You really should set a configuration value for eaglei.repository.namespace");
                }
                log.warn((Object)("Using emergency default for namespace prefix URI (probably wrong) = " + this.defaultNamespace));
            }
        }
        return this.defaultNamespace;
    }

    public String getConfigurationProperty(String key) {
        return this.configuration.getString(key);
    }

    public String getConfigurationProperty(String key, String dflt) {
        String result = this.configuration.getString(key);
        return result == null ? dflt : result;
    }

    public String[] getConfigurationPropertyArray(String key) {
        return this.configuration.containsKey(key) ? this.configuration.getStringArray(key) : null;
    }

    public void incrementGeneration() {
        int gen = 1 + (Integer)this.servletContext.getAttribute("org.eaglei.repository.Generation");
        this.servletContext.setAttribute("org.eaglei.repository.Generation", (Object)new Integer(gen));
        log.debug((Object)("Generation is incremented to " + gen));
    }

    public boolean isSessionStale(HttpSession session) {
        Integer sessionGen = (Integer)session.getAttribute("org.eaglei.repository.Generation");
        Integer ctxGen = (Integer)this.servletContext.getAttribute("org.eaglei.repository.Generation");
        boolean result = sessionGen != null && sessionGen < ctxGen;
        session.setAttribute("org.eaglei.repository.Generation", (Object)ctxGen);
        return result;
    }

    public Reader getWebappResourceAsReader(String path) {
        if (this.servletContext == null) {
            log.error((Object)"getWebappResourceAsStream: currentContext not set!");
            return null;
        }
        return new InputStreamReader(this.servletContext.getResourceAsStream(path));
    }

    public String getProjectVersion() {
        return this.getBuildProperties().getProperty("version");
    }

    public String getRevision() {
        return this.getBuildProperties().getProperty("revision");
    }

    public String getTimestamp() {
        return this.getBuildProperties().getProperty("timestamp");
    }

    private Properties getBuildProperties() {
        if (this.buildProperties == null) {
            this.buildProperties = new Properties();
            try {
                this.buildProperties.load(this.getClass().getClassLoader().getResourceAsStream("build.properties"));
            }
            catch (IOException e) {
                log.error((Object)"Failed loading build.properties: ", (Throwable)e);
            }
        }
        return this.buildProperties;
    }

    public File getHomeDirectory() throws IOException {
        String home = System.getProperty("org.eaglei.repository.home");
        File result = null;
        boolean haveSysProp = home != null;
        result = !haveSysProp ? new File(System.getProperty("user.home"), "eaglei" + File.separator + "repository") : new File(home);
        if (!result.exists() && !result.mkdirs()) {
            log.fatal((Object)("The configured home directory does not exist: " + result.toString()));
            throw new IOException("The configured home directory does not exist: " + result.toString());
        }
        if (!result.isDirectory()) {
            log.fatal((Object)("The configured home directory is not a directory or is protected: " + result.toString()));
            throw new IOException("The configured home directory is not a directory or is protected: " + result.toString());
        }
        log.debug((Object)("repository home directory = " + result.toString()));
        if (!haveSysProp) {
            System.setProperty("org.eaglei.repository.home", result.toString());
        }
        return result;
    }

    public File getBackupDirectory() throws IOException {
        String home = System.getProperty("org.eaglei.repository.backup");
        File result = null;
        boolean haveProp = home != null;
        result = !haveProp ? new File(this.getHomeDirectory(), "backup") : new File(home);
        if (!result.exists() && !result.mkdirs()) {
            log.fatal((Object)("The configured home directory does not exist: " + result.toString()));
            throw new IOException("The configured home directory does not exist: " + result.toString());
        }
        if (!result.isDirectory()) {
            log.fatal((Object)("The configured home directory is not a directory or is protected: " + result.toString()));
            throw new IOException("The configured home directory is not a directory or is protected: " + result.toString());
        }
        log.debug((Object)("backup home directory = " + result.toString()));
        if (!haveProp) {
            System.setProperty("org.eaglei.repository.backup", result.toString());
        }
        return result;
    }

    public synchronized void setLastModified(Date lm) {
        if (this.lastModified.before(lm)) {
            this.lastModified = lm;
        }
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    static {
        graphInitFile.put(REPO.NAMESPACE_URI, "repository-ont.n3");
        graphInitFile.put(REPO.NG_INTERNAL, "repository-internal.n3");
        graphInitFile.put(REPO.NG_QUERY, "query-macros.n3");
        instance = null;
    }
}

