<%@ page import="java.lang.management.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.IOException" %>

<%!
    private void printCol(JspWriter oot, long data)
        throws IOException
    {

        oot.print("<td align=\"right\"><tt>");
        oot.print(String.format("%,-16d bytes", data));
        oot.print("</tt></td>");
    }
    private void doUsage(JspWriter oot, MemoryUsage mu, String label, boolean first)
        throws IOException
    {
        if (first)
            oot.println(
               "<tr>"+
               " <th width=\"20%\">&nbsp;</th>"+
               " <th  align=\"right\" width=\"20%\">Initial</th>"+
               " <th  align=\"right\" width=\"20%\">Used</th>"+
               " <th  align=\"right\" width=\"20%\">Committed</th>"+
               " <th  align=\"right\" width=\"20%\">Maximum</th>"+
               "</tr>");
        oot.println("<tr><th align=\"left\">"+label+"</th>");

        printCol(oot, mu.getInit());
        printCol(oot, mu.getUsed());
        printCol(oot, mu.getCommitted());
        printCol(oot, mu.getMax());

        oot.println("</tr>");
    }
%>
<html>
<head>
  <title>JVM Memory Utilization</title>
</head>
<body>
<h2 align="center">JVM Memory Utilization</h2>
<div align="center">At Time: <%= new Date().toString() %></div>
<table border="0" width="100%">
 <tr><td bgcolor="#CCCCCC" colspan="2" align="center"><h3>Memory MXBean</h3></td></tr>
  <th width="20%">Heap Memory Usage</td>
   <td><tt>
    <%= ManagementFactory.getMemoryMXBean().getHeapMemoryUsage() %>
   </tt></td>
 </tr>
 <tr>
  <th>Non-Heap Memory Usage</th>
  <td><tt>
   <%= ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage() %>
  </td>
 </tr>
 <tr><td colspan="2">&nbsp;</td></tr>
 <tr><td bgcolor="#CCCCCC" colspan="2" align="center"><h3>Memory Pool MXBeans</h3></td></tr>
<%
        Iterator iter = ManagementFactory.getMemoryPoolMXBeans().iterator();
        while (iter.hasNext()) {
            MemoryPoolMXBean item = (MemoryPoolMXBean) iter.next();
%>
      <tr>
       <td colspan="2">
         <table border="0" width="80%" align="center" style="border: 1px #98AAB1 solid;">
           <tr>
            <th colspan="5" align="center">
              <%= item.getName() %> (<%= item.getType() %>)
            </th>
           </tr>

           <% doUsage(out, item.getUsage(), "Usage", true); %>
           <% doUsage(out, item.getPeakUsage(), "Peak Usage", false); %>

<%      MemoryUsage cu = item.getCollectionUsage();
        if (cu != null) {
%>
           <% doUsage(out, cu, "Collection Usage", false); %>
<% } %>
         </table>
      </td></tr>
      <tr><td colspan="2">&nbsp;</td></tr>
<%
}
%>
</table>
</body>
</html>
