package org.eaglei.repository.status;

import org.eaglei.repository.status.ErrorSendingException;
import javax.servlet.http.HttpServletResponse;

/**
 * Signal a fatal runtime error that should result in a
 * 403 (Forbidden) status returned to the HTTP client.
 *
 * @author lcs
 * @version $Id: $
 */
public class ForbiddenException extends ErrorSendingException
{
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return HttpServletResponse.SC_FORBIDDEN;
    }

    /**
     * <p>Constructor for ForbiddenException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public ForbiddenException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for ForbiddenException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public ForbiddenException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for ForbiddenException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public ForbiddenException(Throwable cause)
    {
        super(cause);
    }
}
