package org.eaglei.repository.format;

import java.io.PrintStream;
import java.io.OutputStream;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.TupleQueryResultHandlerException;

/**
 * Tuple query results writer for plain text format.
 * Very simple and stupid "TSV" (tab-separated values)
 * format, not even checking for embedded tabs in values.
 * Perhaps it would be better to have a more human-readable
 * text format (e.g. columns aligned by whitespace, maybe borders)
 * but this was quick and expedient.
 *
 * @author lcs
 * @version $Id: $
 */
public class SPARQLTextWriter implements TupleQueryResultWriter
{
    /** Constant <code>theFormat</code> */
    public static TupleQueryResultFormat theFormat =
        new TupleQueryResultFormat("Plain Old Text", "text/plain", ".txt");

    private PrintStream out = null;

    private List<String> columns = null;

    /**
     * <p>Constructor for SPARQLTextWriter.</p>
     *
     * @param out a {@link java.io.OutputStream} object.
     */
    public SPARQLTextWriter(OutputStream out)
    {
        super();
        this.out = new PrintStream(out);
    }

    /**
     * <p>getTupleQueryResultFormat</p>
     *
     * @return a {@link org.openrdf.query.resultio.TupleQueryResultFormat} object.
     */
    public TupleQueryResultFormat getTupleQueryResultFormat()
    {
        return theFormat;
    }

    /** {@inheritDoc} */
    public void startQueryResult(List<String> bindingNames)
                          throws TupleQueryResultHandlerException
    {
        columns = bindingNames;
        for (String bn : bindingNames) {
            out.print(bn+"\t");
        }
        out.println();
    }

    /**
     * <p>endQueryResult</p>
     *
     * @throws org.openrdf.query.TupleQueryResultHandlerException if any.
     */
    public void endQueryResult()
                        throws TupleQueryResultHandlerException
    {
    }

    /** {@inheritDoc} */
    public void handleSolution(BindingSet bs)
                        throws TupleQueryResultHandlerException
    {
        for (String bn : columns) {
            out.print(bs.hasBinding(bn) ? bs.getValue(bn).toString() : " ");
            out.print("\t");
        }
        out.println();
    }
}
